# -*- coding: utf-8 -*-

# DO NOT EDIT THIS FILE!
# This file has been autogenerated by dephell <3
# https://github.com/dephell/dephell

try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

import os.path

readme = ''
here = os.path.abspath(os.path.dirname(__file__))
readme_path = os.path.join(here, 'README.rst')
if os.path.exists(readme_path):
    with open(readme_path, 'rb') as stream:
        readme = stream.read().decode('utf8')

setup(
    long_description=readme,
    name='flakehell',
    version='0.4.3',
    description='Flake8 wrapper to make it nice and configurable',
    python_requires='>=3.5',
    project_urls={
        "Documentation": "https://flakehell.readthedocs.io/",
        "homepage": "https://github.com/life4/flakehell"
    },
    author='Gram (@orsinium)',
    author_email='master_fess@mail.ru',
    classifiers=[
        'Development Status :: 5 - Production/Stable', 'Environment :: Console',
        'Framework :: Flake8', 'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3', 'Programming Language :: Python',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Topic :: Software Development :: Quality Assurance'
    ],
    entry_points={
        "console_scripts": [
            "flakehell = flakehell:entrypoint",
            "flake8helled = flakehell:flake8_entrypoint"
        ],
        "flake8.extension": ["pylint = flakehell.plugins:PyLintChecker"],
        "flake8.report": [
            "baseline = flakehell.formatters:BaseLineFormatter",
            "colored = flakehell.formatters:ColoredFormatter",
            "gitlab = flakehell.formatters:GitlabFormatter",
            "grouped = flakehell.formatters:GroupedFormatter",
            "json = flakehell.formatters:JSONFormatter",
            "stat = flakehell.formatters:StatFormatter"
        ]
    },
    packages=[
        'flakehell', 'flakehell._logic', 'flakehell._patched',
        'flakehell.commands', 'flakehell.formatters', 'flakehell.plugins'
    ],
    package_dir={"": "."},
    package_data={},
    install_requires=[
        'entrypoints', 'flake8>=3.8.0', 'pygments', 'pylint', 'termcolor',
        'toml', 'urllib3'
    ],
    extras_require={
        "dev": [
            "dlint", "flake8-alfred", "flake8-annotations-complexity",
            "flake8-bandit", "flake8-broken-line", "flake8-bugbear",
            "flake8-builtins", "flake8-coding", "flake8-commas",
            "flake8-comprehensions", "flake8-debugger", "flake8-django",
            "flake8-docstrings", "flake8-eradicate", "flake8-executable",
            "flake8-future-import", "flake8-isort", "flake8-logging-format",
            "flake8-mock", "flake8-mutable", "flake8-pep3101", "flake8-pie",
            "flake8-print", "flake8-pytest", "flake8-quotes",
            "flake8-rst-docstrings", "flake8-scrapy", "flake8-strict",
            "flake8-string-format", "flake8-variables-names", "mccabe",
            "pep8-naming", "pytest", "typing-extensions",
            "wemake-python-styleguide"
        ],
        "docs": [
            "alabaster", "pygments-github-lexers", "recommonmark", "sphinx"
        ]
    },
)
