"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.  # noqa: E501

    The version of the OpenAPI document: 1.0.171
    Contact: support@infobip.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from infobip_api_client.api_client import ApiClient, Endpoint as _Endpoint
from infobip_api_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)
from infobip_api_client.model.tfa_api_exception import TfaApiException
from infobip_api_client.model.tfa_application_request import TfaApplicationRequest
from infobip_api_client.model.tfa_application_response import TfaApplicationResponse
from infobip_api_client.model.tfa_create_message_request import TfaCreateMessageRequest
from infobip_api_client.model.tfa_message import TfaMessage
from infobip_api_client.model.tfa_resend_pin_request import TfaResendPinRequest
from infobip_api_client.model.tfa_start_authentication_request import (
    TfaStartAuthenticationRequest,
)
from infobip_api_client.model.tfa_start_authentication_response import (
    TfaStartAuthenticationResponse,
)
from infobip_api_client.model.tfa_update_message_request import TfaUpdateMessageRequest
from infobip_api_client.model.tfa_verification_response import TfaVerificationResponse
from infobip_api_client.model.tfa_verify_pin_request import TfaVerifyPinRequest
from infobip_api_client.model.tfa_verify_pin_response import TfaVerifyPinResponse


class TfaApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_tfa_application(self, **kwargs):
            """Create 2FA application  # noqa: E501

            Create and configure a new 2FA application.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_tfa_application(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                tfa_application_request (TfaApplicationRequest): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TfaApplicationResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            return self.call_with_http_info(**kwargs)

        self.create_tfa_application = _Endpoint(
            settings={
                "response_type": (TfaApplicationResponse,),
                "auth": ["APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"],
                "endpoint_path": "/2fa/2/applications",
                "operation_id": "create_tfa_application",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "tfa_application_request",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "tfa_application_request": (TfaApplicationRequest,),
                },
                "attribute_map": {},
                "location_map": {
                    "tfa_application_request": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "application/xml"],
                "content_type": ["application/json", "application/xml"],
            },
            api_client=api_client,
            callable=__create_tfa_application,
        )

        def __create_tfa_message_template(self, app_id, **kwargs):
            """Create 2FA message template  # noqa: E501

            Once you have your [2FA application](#channels/sms/create-2fa-message-template), create one or more message templates where your PIN will be dynamically included when you send the PIN message.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_tfa_message_template(app_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): ID of application for which requested message was created.

            Keyword Args:
                tfa_create_message_request (TfaCreateMessageRequest): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TfaMessage
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["app_id"] = app_id
            return self.call_with_http_info(**kwargs)

        self.create_tfa_message_template = _Endpoint(
            settings={
                "response_type": (TfaMessage,),
                "auth": ["APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"],
                "endpoint_path": "/2fa/2/applications/{appId}/messages",
                "operation_id": "create_tfa_message_template",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "app_id",
                    "tfa_create_message_request",
                ],
                "required": [
                    "app_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "app_id": (str,),
                    "tfa_create_message_request": (TfaCreateMessageRequest,),
                },
                "attribute_map": {
                    "app_id": "appId",
                },
                "location_map": {
                    "app_id": "path",
                    "tfa_create_message_request": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "application/xml"],
                "content_type": ["application/json", "application/xml"],
            },
            api_client=api_client,
            callable=__create_tfa_message_template,
        )

        def __get_tfa_application(self, app_id, **kwargs):
            """Get 2FA application  # noqa: E501

            Get a single 2FA application to see its configuration details.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_tfa_application(app_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): Requested application ID.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TfaApplicationResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["app_id"] = app_id
            return self.call_with_http_info(**kwargs)

        self.get_tfa_application = _Endpoint(
            settings={
                "response_type": (TfaApplicationResponse,),
                "auth": ["APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"],
                "endpoint_path": "/2fa/2/applications/{appId}",
                "operation_id": "get_tfa_application",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "app_id",
                ],
                "required": [
                    "app_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "app_id": (str,),
                },
                "attribute_map": {
                    "app_id": "appId",
                },
                "location_map": {
                    "app_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "application/xml"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__get_tfa_application,
        )

        def __get_tfa_applications(self, **kwargs):
            """Get 2FA applications  # noqa: E501

            An application is a container for 2FA message templates. Use this method to list your applications.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_tfa_applications(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [TfaApplicationResponse]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            return self.call_with_http_info(**kwargs)

        self.get_tfa_applications = _Endpoint(
            settings={
                "response_type": ([TfaApplicationResponse],),
                "auth": ["APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"],
                "endpoint_path": "/2fa/2/applications",
                "operation_id": "get_tfa_applications",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {},
                "attribute_map": {},
                "location_map": {},
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "application/xml"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__get_tfa_applications,
        )

        def __get_tfa_message_template(self, app_id, msg_id, **kwargs):
            """Get 2FA message template  # noqa: E501

            Get a single 2FA message template from an application to see its configuration details.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_tfa_message_template(app_id, msg_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): ID of application for which requested message was created.
                msg_id (str): Requested message ID.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TfaMessage
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["app_id"] = app_id
            kwargs["msg_id"] = msg_id
            return self.call_with_http_info(**kwargs)

        self.get_tfa_message_template = _Endpoint(
            settings={
                "response_type": (TfaMessage,),
                "auth": ["APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"],
                "endpoint_path": "/2fa/2/applications/{appId}/messages/{msgId}",
                "operation_id": "get_tfa_message_template",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "app_id",
                    "msg_id",
                ],
                "required": [
                    "app_id",
                    "msg_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "app_id": (str,),
                    "msg_id": (str,),
                },
                "attribute_map": {
                    "app_id": "appId",
                    "msg_id": "msgId",
                },
                "location_map": {
                    "app_id": "path",
                    "msg_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "application/xml"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__get_tfa_message_template,
        )

        def __get_tfa_message_templates(self, app_id, **kwargs):
            """Get 2FA message templates  # noqa: E501

            List all message templates in a 2FA application.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_tfa_message_templates(app_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): ID of application for which requested message was created.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [TfaMessage]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["app_id"] = app_id
            return self.call_with_http_info(**kwargs)

        self.get_tfa_message_templates = _Endpoint(
            settings={
                "response_type": ([TfaMessage],),
                "auth": ["APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"],
                "endpoint_path": "/2fa/2/applications/{appId}/messages",
                "operation_id": "get_tfa_message_templates",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "app_id",
                ],
                "required": [
                    "app_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "app_id": (str,),
                },
                "attribute_map": {
                    "app_id": "appId",
                },
                "location_map": {
                    "app_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "application/xml"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__get_tfa_message_templates,
        )

        def __get_tfa_verification_status(self, msisdn, app_id, **kwargs):
            """Get 2FA verification status  # noqa: E501

            Check if a phone number is already verified for a specific 2FA application.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_tfa_verification_status(msisdn, app_id, async_req=True)
            >>> result = thread.get()

            Args:
                msisdn (str): Filter by msisdn (phone number) for which verification status is checked.
                app_id (str): ID of 2-FA application for which phone number verification status is requested.

            Keyword Args:
                verified (bool): Filter by verified (true or false).. [optional]
                sent (bool): Filter by message sent status (true or false).. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TfaVerificationResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["msisdn"] = msisdn
            kwargs["app_id"] = app_id
            return self.call_with_http_info(**kwargs)

        self.get_tfa_verification_status = _Endpoint(
            settings={
                "response_type": (TfaVerificationResponse,),
                "auth": ["APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"],
                "endpoint_path": "/2fa/2/applications/{appId}/verifications",
                "operation_id": "get_tfa_verification_status",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "msisdn",
                    "app_id",
                    "verified",
                    "sent",
                ],
                "required": [
                    "msisdn",
                    "app_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "msisdn": (str,),
                    "app_id": (str,),
                    "verified": (bool,),
                    "sent": (bool,),
                },
                "attribute_map": {
                    "msisdn": "msisdn",
                    "app_id": "appId",
                    "verified": "verified",
                    "sent": "sent",
                },
                "location_map": {
                    "msisdn": "query",
                    "app_id": "path",
                    "verified": "query",
                    "sent": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "application/xml"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__get_tfa_verification_status,
        )

        def __resend_tfa_pin_code_over_sms(self, pin_id, **kwargs):
            """Resend 2FA PIN code over SMS  # noqa: E501

            If needed, you can resend the same (previously sent) PIN code over SMS.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.resend_tfa_pin_code_over_sms(pin_id, async_req=True)
            >>> result = thread.get()

            Args:
                pin_id (str): ID of the pin code that has to be verified.

            Keyword Args:
                tfa_resend_pin_request (TfaResendPinRequest): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TfaStartAuthenticationResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["pin_id"] = pin_id
            return self.call_with_http_info(**kwargs)

        self.resend_tfa_pin_code_over_sms = _Endpoint(
            settings={
                "response_type": (TfaStartAuthenticationResponse,),
                "auth": ["APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"],
                "endpoint_path": "/2fa/2/pin/{pinId}/resend",
                "operation_id": "resend_tfa_pin_code_over_sms",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "pin_id",
                    "tfa_resend_pin_request",
                ],
                "required": [
                    "pin_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "pin_id": (str,),
                    "tfa_resend_pin_request": (TfaResendPinRequest,),
                },
                "attribute_map": {
                    "pin_id": "pinId",
                },
                "location_map": {
                    "pin_id": "path",
                    "tfa_resend_pin_request": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "application/xml"],
                "content_type": ["application/json", "application/xml"],
            },
            api_client=api_client,
            callable=__resend_tfa_pin_code_over_sms,
        )

        def __resend_tfa_pin_code_over_voice(self, pin_id, **kwargs):
            """Resend 2FA PIN code over Voice  # noqa: E501

            If needed, you can resend the same (previously sent) PIN code over Voice.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.resend_tfa_pin_code_over_voice(pin_id, async_req=True)
            >>> result = thread.get()

            Args:
                pin_id (str): ID of the pin code that has to be verified.

            Keyword Args:
                tfa_resend_pin_request (TfaResendPinRequest): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TfaStartAuthenticationResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["pin_id"] = pin_id
            return self.call_with_http_info(**kwargs)

        self.resend_tfa_pin_code_over_voice = _Endpoint(
            settings={
                "response_type": (TfaStartAuthenticationResponse,),
                "auth": ["APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"],
                "endpoint_path": "/2fa/2/pin/{pinId}/resend/voice",
                "operation_id": "resend_tfa_pin_code_over_voice",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "pin_id",
                    "tfa_resend_pin_request",
                ],
                "required": [
                    "pin_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "pin_id": (str,),
                    "tfa_resend_pin_request": (TfaResendPinRequest,),
                },
                "attribute_map": {
                    "pin_id": "pinId",
                },
                "location_map": {
                    "pin_id": "path",
                    "tfa_resend_pin_request": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "application/xml"],
                "content_type": ["application/json", "application/xml"],
            },
            api_client=api_client,
            callable=__resend_tfa_pin_code_over_voice,
        )

        def __send_tfa_pin_code_over_sms(self, **kwargs):
            """Send 2FA PIN code over SMS  # noqa: E501

            Send a PIN code over SMS using a previously created [message template](#channels/sms/create-2fa-message-template).  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.send_tfa_pin_code_over_sms(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                nc_needed (bool): Indicates if Number Lookup is needed before sending the 2FA message. If the parameter value is true, Number Lookup will be requested before sending the SMS. If the value is false, the SMS will be sent without requesting Number Lookup. Field's default value is `true`.. [optional]
                tfa_start_authentication_request (TfaStartAuthenticationRequest): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TfaStartAuthenticationResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            return self.call_with_http_info(**kwargs)

        self.send_tfa_pin_code_over_sms = _Endpoint(
            settings={
                "response_type": (TfaStartAuthenticationResponse,),
                "auth": ["APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"],
                "endpoint_path": "/2fa/2/pin",
                "operation_id": "send_tfa_pin_code_over_sms",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "nc_needed",
                    "tfa_start_authentication_request",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "nc_needed": (bool,),
                    "tfa_start_authentication_request": (
                        TfaStartAuthenticationRequest,
                    ),
                },
                "attribute_map": {
                    "nc_needed": "ncNeeded",
                },
                "location_map": {
                    "nc_needed": "query",
                    "tfa_start_authentication_request": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "application/xml"],
                "content_type": ["application/json", "application/xml"],
            },
            api_client=api_client,
            callable=__send_tfa_pin_code_over_sms,
        )

        def __send_tfa_pin_code_over_voice(self, **kwargs):
            """Send 2FA PIN code over Voice  # noqa: E501

            Send a PIN code over Voice using previously created [message template](#channels/sms/create-2fa-message-template).  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.send_tfa_pin_code_over_voice(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                tfa_start_authentication_request (TfaStartAuthenticationRequest): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TfaStartAuthenticationResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            return self.call_with_http_info(**kwargs)

        self.send_tfa_pin_code_over_voice = _Endpoint(
            settings={
                "response_type": (TfaStartAuthenticationResponse,),
                "auth": ["APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"],
                "endpoint_path": "/2fa/2/pin/voice",
                "operation_id": "send_tfa_pin_code_over_voice",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "tfa_start_authentication_request",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "tfa_start_authentication_request": (
                        TfaStartAuthenticationRequest,
                    ),
                },
                "attribute_map": {},
                "location_map": {
                    "tfa_start_authentication_request": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "application/xml"],
                "content_type": ["application/json", "application/xml"],
            },
            api_client=api_client,
            callable=__send_tfa_pin_code_over_voice,
        )

        def __update_tfa_application(self, app_id, **kwargs):
            """Update 2FA application  # noqa: E501

            Change configuration options for your existing 2FA application.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_tfa_application(app_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): ID of application that should be updated.

            Keyword Args:
                tfa_application_request (TfaApplicationRequest): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TfaApplicationResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["app_id"] = app_id
            return self.call_with_http_info(**kwargs)

        self.update_tfa_application = _Endpoint(
            settings={
                "response_type": (TfaApplicationResponse,),
                "auth": ["APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"],
                "endpoint_path": "/2fa/2/applications/{appId}",
                "operation_id": "update_tfa_application",
                "http_method": "PUT",
                "servers": None,
            },
            params_map={
                "all": [
                    "app_id",
                    "tfa_application_request",
                ],
                "required": [
                    "app_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "app_id": (str,),
                    "tfa_application_request": (TfaApplicationRequest,),
                },
                "attribute_map": {
                    "app_id": "appId",
                },
                "location_map": {
                    "app_id": "path",
                    "tfa_application_request": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "application/xml"],
                "content_type": ["application/json", "application/xml"],
            },
            api_client=api_client,
            callable=__update_tfa_application,
        )

        def __update_tfa_message_template(self, app_id, msg_id, **kwargs):
            """Update 2FA message template  # noqa: E501

            Change configuration options for your existing 2FA application message template.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_tfa_message_template(app_id, msg_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str): ID of application for which requested message was created.
                msg_id (str): Requested message ID.

            Keyword Args:
                tfa_update_message_request (TfaUpdateMessageRequest): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TfaMessage
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["app_id"] = app_id
            kwargs["msg_id"] = msg_id
            return self.call_with_http_info(**kwargs)

        self.update_tfa_message_template = _Endpoint(
            settings={
                "response_type": (TfaMessage,),
                "auth": ["APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"],
                "endpoint_path": "/2fa/2/applications/{appId}/messages/{msgId}",
                "operation_id": "update_tfa_message_template",
                "http_method": "PUT",
                "servers": None,
            },
            params_map={
                "all": [
                    "app_id",
                    "msg_id",
                    "tfa_update_message_request",
                ],
                "required": [
                    "app_id",
                    "msg_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "app_id": (str,),
                    "msg_id": (str,),
                    "tfa_update_message_request": (TfaUpdateMessageRequest,),
                },
                "attribute_map": {
                    "app_id": "appId",
                    "msg_id": "msgId",
                },
                "location_map": {
                    "app_id": "path",
                    "msg_id": "path",
                    "tfa_update_message_request": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "application/xml"],
                "content_type": ["application/json", "application/xml"],
            },
            api_client=api_client,
            callable=__update_tfa_message_template,
        )

        def __verify_tfa_phone_number(self, pin_id, **kwargs):
            """Verify phone number  # noqa: E501

            Verify a phone number to confirm successful 2FA authentication.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.verify_tfa_phone_number(pin_id, async_req=True)
            >>> result = thread.get()

            Args:
                pin_id (str): ID of the pin code that has to be verified.

            Keyword Args:
                tfa_verify_pin_request (TfaVerifyPinRequest): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TfaVerifyPinResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["pin_id"] = pin_id
            return self.call_with_http_info(**kwargs)

        self.verify_tfa_phone_number = _Endpoint(
            settings={
                "response_type": (TfaVerifyPinResponse,),
                "auth": ["APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"],
                "endpoint_path": "/2fa/2/pin/{pinId}/verify",
                "operation_id": "verify_tfa_phone_number",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "pin_id",
                    "tfa_verify_pin_request",
                ],
                "required": [
                    "pin_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "pin_id": (str,),
                    "tfa_verify_pin_request": (TfaVerifyPinRequest,),
                },
                "attribute_map": {
                    "pin_id": "pinId",
                },
                "location_map": {
                    "pin_id": "path",
                    "tfa_verify_pin_request": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "application/xml"],
                "content_type": ["application/json", "application/xml"],
            },
            api_client=api_client,
            callable=__verify_tfa_phone_number,
        )
