"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.  # noqa: E501

    The version of the OpenAPI document: 1.0.171
    Contact: support@infobip.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from infobip_api_client.api_client import ApiClient, Endpoint as _Endpoint
from infobip_api_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)
from infobip_api_client.model.sms_advanced_binary_request import (
    SmsAdvancedBinaryRequest,
)
from infobip_api_client.model.sms_advanced_textual_request import (
    SmsAdvancedTextualRequest,
)
from infobip_api_client.model.sms_api_exception import SmsApiException
from infobip_api_client.model.sms_delivery_result import SmsDeliveryResult
from infobip_api_client.model.sms_logs_response import SmsLogsResponse
from infobip_api_client.model.sms_preview_request import SmsPreviewRequest
from infobip_api_client.model.sms_preview_response import SmsPreviewResponse
from infobip_api_client.model.sms_response import SmsResponse


class SendSmsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __get_outbound_sms_message_delivery_reports(self, **kwargs):
            """Get outbound SMS message delivery reports  # noqa: E501

            If you are for any reason unable to receive real time delivery reports on your endpoint, you can use this API method to learn if and when the message has been delivered to the recipient. Each request will return a batch of delivery reports - only once. The following API request will return only new reports that arrived since the last API request.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_outbound_sms_message_delivery_reports(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                bulk_id (str): ID of bulk which delivery report is requested.. [optional]
                message_id (str): ID of SMS which delivery report is requested.. [optional]
                limit (int): Maximal number of delivery reports that will be returned.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SmsDeliveryResult
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            return self.call_with_http_info(**kwargs)

        self.get_outbound_sms_message_delivery_reports = _Endpoint(
            settings={
                "response_type": (SmsDeliveryResult,),
                "auth": ["APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"],
                "endpoint_path": "/sms/1/reports",
                "operation_id": "get_outbound_sms_message_delivery_reports",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "bulk_id",
                    "message_id",
                    "limit",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "bulk_id": (str,),
                    "message_id": (str,),
                    "limit": (int,),
                },
                "attribute_map": {
                    "bulk_id": "bulkId",
                    "message_id": "messageId",
                    "limit": "limit",
                },
                "location_map": {
                    "bulk_id": "query",
                    "message_id": "query",
                    "limit": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "application/xml"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__get_outbound_sms_message_delivery_reports,
        )

        def __get_outbound_sms_message_logs(self, **kwargs):
            """Get outbound SMS message logs  # noqa: E501

            You should use this method for displaying logs in the user interface or for some other less frequent usage. See [message delivery reports](#channels/sms/get-outbound-sms-message-delivery-reports) if your use case is to verify message delivery.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_outbound_sms_message_logs(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _from (str): Sender address.. [optional]
                to (str): Destination address.. [optional]
                bulk_id ([str]): Bulk ID for which log is requested.. [optional]
                message_id ([str]): SMS ID for which log is requested.. [optional]
                general_status (str): Sent SMS status.. [optional]
                sent_since (datetime): Lower limit on date and time of sending SMS. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.. [optional]
                sent_until (datetime): Upper limit on date and time of sending SMS. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.. [optional]
                limit (int): Maximal number of messages in returned logs. Limit should be between `1` and `1000`. If you want to fetch more than 1000 logs you can retrieve them in pages using `sentSince` and `sentUntil` parameters. Defaults to `50`.. [optional]
                mcc (str): Mobile country code.. [optional]
                mnc (str): Mobile network code.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SmsLogsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            return self.call_with_http_info(**kwargs)

        self.get_outbound_sms_message_logs = _Endpoint(
            settings={
                "response_type": (SmsLogsResponse,),
                "auth": ["APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"],
                "endpoint_path": "/sms/1/logs",
                "operation_id": "get_outbound_sms_message_logs",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "_from",
                    "to",
                    "bulk_id",
                    "message_id",
                    "general_status",
                    "sent_since",
                    "sent_until",
                    "limit",
                    "mcc",
                    "mnc",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "_from": (str,),
                    "to": (str,),
                    "bulk_id": ([str],),
                    "message_id": ([str],),
                    "general_status": (str,),
                    "sent_since": (datetime,),
                    "sent_until": (datetime,),
                    "limit": (int,),
                    "mcc": (str,),
                    "mnc": (str,),
                },
                "attribute_map": {
                    "_from": "from",
                    "to": "to",
                    "bulk_id": "bulkId",
                    "message_id": "messageId",
                    "general_status": "generalStatus",
                    "sent_since": "sentSince",
                    "sent_until": "sentUntil",
                    "limit": "limit",
                    "mcc": "mcc",
                    "mnc": "mnc",
                },
                "location_map": {
                    "_from": "query",
                    "to": "query",
                    "bulk_id": "query",
                    "message_id": "query",
                    "general_status": "query",
                    "sent_since": "query",
                    "sent_until": "query",
                    "limit": "query",
                    "mcc": "query",
                    "mnc": "query",
                },
                "collection_format_map": {
                    "bulk_id": "multi",
                    "message_id": "multi",
                },
            },
            headers_map={
                "accept": ["application/json", "application/xml"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__get_outbound_sms_message_logs,
        )

        def __preview_sms_message(self, **kwargs):
            """Preview SMS message  # noqa: E501

            Avoid unpleasant surprises and check how different message configurations will affect your message text, number of characters and message parts.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.preview_sms_message(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                sms_preview_request (SmsPreviewRequest): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SmsPreviewResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            return self.call_with_http_info(**kwargs)

        self.preview_sms_message = _Endpoint(
            settings={
                "response_type": (SmsPreviewResponse,),
                "auth": ["APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"],
                "endpoint_path": "/sms/1/preview",
                "operation_id": "preview_sms_message",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "sms_preview_request",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "sms_preview_request": (SmsPreviewRequest,),
                },
                "attribute_map": {},
                "location_map": {
                    "sms_preview_request": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "application/xml"],
                "content_type": ["application/json", "application/xml"],
            },
            api_client=api_client,
            callable=__preview_sms_message,
        )

        def __send_binary_sms_message(self, **kwargs):
            """Send binary SMS message  # noqa: E501

            Send single or multiple binary messages to one or more destination address.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.send_binary_sms_message(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                sms_advanced_binary_request (SmsAdvancedBinaryRequest): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SmsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            return self.call_with_http_info(**kwargs)

        self.send_binary_sms_message = _Endpoint(
            settings={
                "response_type": (SmsResponse,),
                "auth": ["APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"],
                "endpoint_path": "/sms/2/binary/advanced",
                "operation_id": "send_binary_sms_message",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "sms_advanced_binary_request",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "sms_advanced_binary_request": (SmsAdvancedBinaryRequest,),
                },
                "attribute_map": {},
                "location_map": {
                    "sms_advanced_binary_request": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "application/xml"],
                "content_type": ["application/json", "application/xml"],
            },
            api_client=api_client,
            callable=__send_binary_sms_message,
        )

        def __send_sms_message(self, **kwargs):
            """Send SMS message  # noqa: E501

            99% of all use cases can be achieved by using this API method. Everything from sending a simple single message to a single destination, up to batch sending of personalized messages to the thousands of recipients with a single API request. Language, transliteration, scheduling and every advanced feature you can think of is supported.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.send_sms_message(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                sms_advanced_textual_request (SmsAdvancedTextualRequest): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SmsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            return self.call_with_http_info(**kwargs)

        self.send_sms_message = _Endpoint(
            settings={
                "response_type": (SmsResponse,),
                "auth": ["APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"],
                "endpoint_path": "/sms/2/text/advanced",
                "operation_id": "send_sms_message",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "sms_advanced_textual_request",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "sms_advanced_textual_request": (SmsAdvancedTextualRequest,),
                },
                "attribute_map": {},
                "location_map": {
                    "sms_advanced_textual_request": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "application/xml"],
                "content_type": ["application/json", "application/xml"],
            },
            api_client=api_client,
            callable=__send_sms_message,
        )
