"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.  # noqa: E501

    The version of the OpenAPI document: 1.0.171
    Contact: support@infobip.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from infobip_api_client.api_client import ApiClient, Endpoint as _Endpoint
from infobip_api_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)
from infobip_api_client.model.sms_api_exception import SmsApiException
from infobip_api_client.model.sms_inbound_message_result import SmsInboundMessageResult


class ReceiveSmsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __get_inbound_sms_messages(self, **kwargs):
            """Get inbound SMS messages  # noqa: E501

            If for some reason you are unable to receive incoming SMS at the endpoint of your choice in real time, you can use this API call to fetch messages. Each request will return a batch of received messages - only once. The following API request will return only new messages that arrived since the last API request.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_inbound_sms_messages(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximal number of received messages that will be returned.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SmsInboundMessageResult
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            return self.call_with_http_info(**kwargs)

        self.get_inbound_sms_messages = _Endpoint(
            settings={
                "response_type": (SmsInboundMessageResult,),
                "auth": ["APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"],
                "endpoint_path": "/sms/1/inbox/reports",
                "operation_id": "get_inbound_sms_messages",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "limit",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "limit": (int,),
                },
                "attribute_map": {
                    "limit": "limit",
                },
                "location_map": {
                    "limit": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "application/xml"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__get_inbound_sms_messages,
        )
