# coding: utf-8

"""
  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.

  Licensed under the Apache License, Version 2.0 (the "License").
  You may not use this file except in compliance with the License.
  A copy of the License is located at

      http://www.apache.org/licenses/LICENSE-2.0

  or in the "license" file accompanying this file. This file is distributed
  on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
  express or implied. See the License for the specific language governing
  permissions and limitations under the License.
"""


"""
    ProductAdvertisingAPI

    https://webservices.amazon.com/paapi5/documentation/index.html  # noqa: E501
"""


import pprint
import re  # noqa: F401

import six


class GetVariationsResource(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    allowed enum values
    """
    BROWSENODEINFO_BROWSENODES = "BrowseNodeInfo.BrowseNodes"
    BROWSENODEINFO_BROWSENODES_ANCESTOR = "BrowseNodeInfo.BrowseNodes.Ancestor"
    BROWSENODEINFO_BROWSENODES_SALESRANK = "BrowseNodeInfo.BrowseNodes.SalesRank"
    BROWSENODEINFO_WEBSITESALESRANK = "BrowseNodeInfo.WebsiteSalesRank"
    CUSTOMERREVIEWS_COUNT = "CustomerReviews.Count"
    CUSTOMERREVIEWS_STARRATING = "CustomerReviews.StarRating"
    IMAGES_PRIMARY_SMALL = "Images.Primary.Small"
    IMAGES_PRIMARY_MEDIUM = "Images.Primary.Medium"
    IMAGES_PRIMARY_LARGE = "Images.Primary.Large"
    IMAGES_VARIANTS_SMALL = "Images.Variants.Small"
    IMAGES_VARIANTS_MEDIUM = "Images.Variants.Medium"
    IMAGES_VARIANTS_LARGE = "Images.Variants.Large"
    ITEMINFO_BYLINEINFO = "ItemInfo.ByLineInfo"
    ITEMINFO_CONTENTINFO = "ItemInfo.ContentInfo"
    ITEMINFO_CONTENTRATING = "ItemInfo.ContentRating"
    ITEMINFO_CLASSIFICATIONS = "ItemInfo.Classifications"
    ITEMINFO_EXTERNALIDS = "ItemInfo.ExternalIds"
    ITEMINFO_FEATURES = "ItemInfo.Features"
    ITEMINFO_MANUFACTUREINFO = "ItemInfo.ManufactureInfo"
    ITEMINFO_PRODUCTINFO = "ItemInfo.ProductInfo"
    ITEMINFO_TECHNICALINFO = "ItemInfo.TechnicalInfo"
    ITEMINFO_TITLE = "ItemInfo.Title"
    ITEMINFO_TRADEININFO = "ItemInfo.TradeInInfo"
    OFFERS_LISTINGS_AVAILABILITY_MAXORDERQUANTITY = "Offers.Listings.Availability.MaxOrderQuantity"
    OFFERS_LISTINGS_AVAILABILITY_MESSAGE = "Offers.Listings.Availability.Message"
    OFFERS_LISTINGS_AVAILABILITY_MINORDERQUANTITY = "Offers.Listings.Availability.MinOrderQuantity"
    OFFERS_LISTINGS_AVAILABILITY_TYPE = "Offers.Listings.Availability.Type"
    OFFERS_LISTINGS_CONDITION = "Offers.Listings.Condition"
    OFFERS_LISTINGS_CONDITION_CONDITIONNOTE = "Offers.Listings.Condition.ConditionNote"
    OFFERS_LISTINGS_CONDITION_SUBCONDITION = "Offers.Listings.Condition.SubCondition"
    OFFERS_LISTINGS_DELIVERYINFO_ISAMAZONFULFILLED = "Offers.Listings.DeliveryInfo.IsAmazonFulfilled"
    OFFERS_LISTINGS_DELIVERYINFO_ISFREESHIPPINGELIGIBLE = "Offers.Listings.DeliveryInfo.IsFreeShippingEligible"
    OFFERS_LISTINGS_DELIVERYINFO_ISPRIMEELIGIBLE = "Offers.Listings.DeliveryInfo.IsPrimeEligible"
    OFFERS_LISTINGS_DELIVERYINFO_SHIPPINGCHARGES = "Offers.Listings.DeliveryInfo.ShippingCharges"
    OFFERS_LISTINGS_ISBUYBOXWINNER = "Offers.Listings.IsBuyBoxWinner"
    OFFERS_LISTINGS_LOYALTYPOINTS_POINTS = "Offers.Listings.LoyaltyPoints.Points"
    OFFERS_LISTINGS_MERCHANTINFO = "Offers.Listings.MerchantInfo"
    OFFERS_LISTINGS_PRICE = "Offers.Listings.Price"
    OFFERS_LISTINGS_PROGRAMELIGIBILITY_ISPRIMEEXCLUSIVE = "Offers.Listings.ProgramEligibility.IsPrimeExclusive"
    OFFERS_LISTINGS_PROGRAMELIGIBILITY_ISPRIMEPANTRY = "Offers.Listings.ProgramEligibility.IsPrimePantry"
    OFFERS_LISTINGS_PROMOTIONS = "Offers.Listings.Promotions"
    OFFERS_LISTINGS_SAVINGBASIS = "Offers.Listings.SavingBasis"
    OFFERS_SUMMARIES_HIGHESTPRICE = "Offers.Summaries.HighestPrice"
    OFFERS_SUMMARIES_LOWESTPRICE = "Offers.Summaries.LowestPrice"
    OFFERS_SUMMARIES_OFFERCOUNT = "Offers.Summaries.OfferCount"
    PARENTASIN = "ParentASIN"
    RENTALOFFERS_LISTINGS_AVAILABILITY_MAXORDERQUANTITY = "RentalOffers.Listings.Availability.MaxOrderQuantity"
    RENTALOFFERS_LISTINGS_AVAILABILITY_MESSAGE = "RentalOffers.Listings.Availability.Message"
    RENTALOFFERS_LISTINGS_AVAILABILITY_MINORDERQUANTITY = "RentalOffers.Listings.Availability.MinOrderQuantity"
    RENTALOFFERS_LISTINGS_AVAILABILITY_TYPE = "RentalOffers.Listings.Availability.Type"
    RENTALOFFERS_LISTINGS_BASEPRICE = "RentalOffers.Listings.BasePrice"
    RENTALOFFERS_LISTINGS_CONDITION = "RentalOffers.Listings.Condition"
    RENTALOFFERS_LISTINGS_CONDITION_CONDITIONNOTE = "RentalOffers.Listings.Condition.ConditionNote"
    RENTALOFFERS_LISTINGS_CONDITION_SUBCONDITION = "RentalOffers.Listings.Condition.SubCondition"
    RENTALOFFERS_LISTINGS_DELIVERYINFO_ISAMAZONFULFILLED = "RentalOffers.Listings.DeliveryInfo.IsAmazonFulfilled"
    RENTALOFFERS_LISTINGS_DELIVERYINFO_ISFREESHIPPINGELIGIBLE = "RentalOffers.Listings.DeliveryInfo.IsFreeShippingEligible"
    RENTALOFFERS_LISTINGS_DELIVERYINFO_ISPRIMEELIGIBLE = "RentalOffers.Listings.DeliveryInfo.IsPrimeEligible"
    RENTALOFFERS_LISTINGS_DELIVERYINFO_SHIPPINGCHARGES = "RentalOffers.Listings.DeliveryInfo.ShippingCharges"
    RENTALOFFERS_LISTINGS_MERCHANTINFO = "RentalOffers.Listings.MerchantInfo"
    VARIATIONSUMMARY_PRICE_HIGHESTPRICE = "VariationSummary.Price.HighestPrice"
    VARIATIONSUMMARY_PRICE_LOWESTPRICE = "VariationSummary.Price.LowestPrice"
    VARIATIONSUMMARY_VARIATIONDIMENSION = "VariationSummary.VariationDimension"

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
    }

    attribute_map = {
    }

    def __init__(self):  # noqa: E501
        """GetVariationsResource - a model defined in Swagger"""  # noqa: E501
        self.discriminator = None

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GetVariationsResource, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GetVariationsResource):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
