# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['sqlmodel',
 'sqlmodel.engine',
 'sqlmodel.ext',
 'sqlmodel.ext.asyncio',
 'sqlmodel.orm',
 'sqlmodel.pool',
 'sqlmodel.sql']

package_data = \
{'': ['*']}

install_requires = \
['SQLAlchemy>=1.4.17,<1.5.0',
 'pydantic>=1.8.2,<2.0.0',
 'sqlalchemy2-stubs>=0.0.2-alpha.5,<0.0.2']

setup_kwargs = {
    'name': 'sqlmodel',
    'version': '0.0.2',
    'description': 'SQLModel, SQL databases in Python, designed for simplicity, compatibility, and robustness.',
    'long_description': '<p align="center">\n  <a href="https://sqlmodel.tiangolo.com"><img src="https://sqlmodel.tiangolo.com/img/logo-margin/logo-margin-vector.svg" alt="SQLModel"></a>\n</p>\n<p align="center">\n    <em>SQLModel, SQL databases in Python, designed for simplicity, compatibility, and robustness.</em>\n</p>\n<p align="center">\n<a href="https://github.com/tiangolo/sqlmodel/actions?query=workflow%3ATest" target="_blank">\n    <img src="https://github.com/tiangolo/sqlmodel/workflows/Test/badge.svg" alt="Test">\n</a>\n<a href="https://github.com/tiangolo/sqlmodel/actions?query=workflow%3APublish" target="_blank">\n    <img src="https://github.com/tiangolo/sqlmodel/workflows/Publish/badge.svg" alt="Publish">\n</a>\n<a href="https://codecov.io/gh/tiangolo/sqlmodel" target="_blank">\n    <img src="https://img.shields.io/codecov/c/github/tiangolo/sqlmodel?color=%2334D058" alt="Coverage">\n</a>\n<a href="https://pypi.org/project/sqlmodel" target="_blank">\n    <img src="https://img.shields.io/pypi/v/sqlmodel?color=%2334D058&label=pypi%20package" alt="Package version">\n</a>\n</p>\n\n---\n\n**Documentation**: <a href="https://sqlmodel.tiangolo.com" target="_blank">https://sqlmodel.tiangolo.com</a>\n\n**Source Code**: <a href="https://github.com/tiangolo/sqlmodel" target="_blank">https://github.com/tiangolo/sqlmodel</a>\n\n---\n\nSQLModel is a library for interacting with <abbr title=\'Also called "Relational databases"\'>SQL databases</abbr> from Python code, with Python objects. It is designed to be intuitive, easy to use, highly compatible, and robust.\n\n**SQLModel** is based on Python type annotations, and powered by <a href="https://pydantic-docs.helpmanual.io/" class="external-link" target="_blank">Pydantic</a> and <a href="https://sqlalchemy.org/" class="external-link" target="_blank">SQLAlchemy</a>.\n\nThe key features are:\n\n* **Intuitive to write**: Great editor support. <abbr title="also known as auto-complete, autocompletion, IntelliSense">Completion</abbr> everywhere. Less time debugging. Designed to be easy to use and learn. Less time reading docs.\n* **Easy to use**: It has sensible defaults and does a lot of work underneath to simplify the code you write.\n* **Compatible**: It is designed to be compatible with **FastAPI**, Pydantic, and SQLAlchemy.\n* **Extensible**: You have all the power of SQLAlchemy and Pydantic underneath.\n* **Short**: Minimize code duplication. A single type annotation does a lot of work. No need to duplicate models in SQLAlchemy and Pydantic.\n\n## SQL Databases in FastAPI\n\n<a href="https://fastapi.tiangolo.com" target="_blank"><img src="https://fastapi.tiangolo.com/img/logo-margin/logo-teal.png" style="width: 20%;"></a>\n\n**SQLModel** is designed to simplify interacting with SQL databases in <a href="https://fastapi.tiangolo.com" class="external-link" target="_blank">FastAPI</a> applications, it was created by the same <a href="https://tiangolo.com/" class="external-link" target="_blank">author</a>. 😁\n\nIt combines SQLAlchemy and Pydantic and tries to simplify the code you write as much as possible, allowing you to reduce the **code duplication to a minimum**, but while getting the **best developer experience** possible.\n\n**SQLModel** is, in fact, a thin layer on top of **Pydantic** and **SQLAlchemy**, carefully designed to be compatible with both.\n\n## Requirements\n\nA recent and currently supported version of Python (right now, <a href="https://www.python.org/downloads/" class="external-link" target="_blank">Python supports versions 3.6 and above</a>).\n\nAs **SQLModel** is based on **Pydantic** and **SQLAlchemy**, it requires them. They will be automatically installed when you install SQLModel.\n\n## Installation\n\n<div class="termy">\n\n```console\n$ pip install sqlmodel\n---> 100%\nSuccessfully installed sqlmodel\n```\n\n</div>\n\n## Example\n\nFor an introduction to databases, SQL, and everything else, see the <a href="https://sqlmodel.tiangolo.com" target="_blank">SQLModel documentation</a>.\n\nHere\'s a quick example. ✨\n\n### A SQL Table\n\nImagine you have a SQL table called `hero` with:\n\n* `id`\n* `name`\n* `secret_name`\n* `age`\n\nAnd you want it to have this data:\n\n| id | name | secret_name | age |\n-----|------|-------------|------|\n| 1  | Deadpond | Dive Wilson | null |\n| 2  | Spider-Boy | Pedro Parqueador | null |\n| 3  | Rusty-Man | Tommy Sharp | 48 |\n\n### Create a SQLModel Model\n\nThen you could create a **SQLModel** model like this:\n\n```Python\nfrom typing import Optional\n\nfrom sqlmodel import Field, SQLModel\n\n\nclass Hero(SQLModel, table=True):\n    id: Optional[int] = Field(default=None, primary_key=True)\n    name: str\n    secret_name: str\n    age: Optional[int] = None\n```\n\nThat class `Hero` is a **SQLModel** model, the equivalent of a SQL table in Python code.\n\nAnd each of those class attributes is equivalent to each **table column**.\n\n### Create Rows\n\nThen you could **create each row** of the table as an **instance** of the model:\n\n```Python\nhero_1 = Hero(name="Deadpond", secret_name="Dive Wilson")\nhero_2 = Hero(name="Spider-Boy", secret_name="Pedro Parqueador")\nhero_3 = Hero(name="Rusty-Man", secret_name="Tommy Sharp", age=48)\n```\n\nThis way, you can use conventional Python code with **classes** and **instances** that represent **tables** and **rows**, and that way communicate with the **SQL database**.\n\n### Editor Support\n\nEverything is designed for you to get the best developer experience possible, with the best editor support.\n\nIncluding **autocompletion**:\n\n<img class="shadow" src="https://sqlmodel.tiangolo.com/img/index/autocompletion01.png">\n\nAnd **inline errors**:\n\n<img class="shadow" src="https://sqlmodel.tiangolo.com/img/index/inline-errors01.png">\n\n### Write to the Database\n\nYou can learn a lot more about **SQLModel** by quickly following the **tutorial**, but if you need a taste right now of how to put all that together and save to the database, you can do this:\n\n```Python hl_lines="18  21  23-27"\nfrom typing import Optional\n\nfrom sqlmodel import Field, Session, SQLModel, create_engine\n\n\nclass Hero(SQLModel, table=True):\n    id: Optional[int] = Field(default=None, primary_key=True)\n    name: str\n    secret_name: str\n    age: Optional[int] = None\n\n\nhero_1 = Hero(name="Deadpond", secret_name="Dive Wilson")\nhero_2 = Hero(name="Spider-Boy", secret_name="Pedro Parqueador")\nhero_3 = Hero(name="Rusty-Man", secret_name="Tommy Sharp", age=48)\n\n\nengine = create_engine("sqlite:///database.db")\n\n\nSQLModel.metadata.create_all(engine)\n\nwith Session(engine) as session:\n    session.add(hero_1)\n    session.add(hero_2)\n    session.add(hero_3)\n    session.commit()\n```\n\nThat will save a **SQLite** database with the 3 heroes.\n\n### Select from the Database\n\nThen you could write queries to select from that same database, for example with:\n\n```Python hl_lines="15-18"\nfrom typing import Optional\n\nfrom sqlmodel import Field, Session, SQLModel, create_engine, select\n\n\nclass Hero(SQLModel, table=True):\n    id: Optional[int] = Field(default=None, primary_key=True)\n    name: str\n    secret_name: str\n    age: Optional[int] = None\n\n\nengine = create_engine("sqlite:///database.db")\n\nwith Session(engine) as session:\n    statement = select(Hero).where(Hero.name == "Spider-Boy")\n    hero = session.exec(statement).first()\n    print(hero)\n```\n\n### Editor Support Everywhere\n\n**SQLModel** was carefully designed to give you the best developer experience and editor support, **even after selecting data** from the database:\n\n<img class="shadow" src="https://sqlmodel.tiangolo.com/img/index/autocompletion02.png">\n\n## SQLAlchemy and Pydantic\n\nThat class `Hero` is a **SQLModel** model.\n\nBut at the same time, ✨ it is a **SQLAlchemy** model ✨. So, you can combine it and use it with other SQLAlchemy models, or you could easily migrate applications with SQLAlchemy to **SQLModel**.\n\nAnd at the same time, ✨ it is also a **Pydantic** model ✨. You can use inheritance with it to define all your **data models** while avoiding code duplication. That makes it very easy to use with **FastAPI**.\n\n## License\n\nThis project is licensed under the terms of the MIT license.\n',
    'author': 'Sebastián Ramírez',
    'author_email': 'tiangolo@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/tiangolo/sqlmodel',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
