from typing import Any, Dict, List, Type, TypeVar

import attr

T = TypeVar("T", bound="CustomFieldOptionsUpdateRequestBody")


@attr.s(auto_attribs=True)
class CustomFieldOptionsUpdateRequestBody:
    """
    Example:
        {'sort_key': 10, 'value': 'Product'}

    Attributes:
        sort_key (int): Sort key used to order the custom field options correctly Example: 10.
        value (str): Human readable name for the custom field option Example: Product.
    """

    sort_key: int
    value: str
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        sort_key = self.sort_key
        value = self.value

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "sort_key": sort_key,
                "value": value,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        sort_key = d.pop("sort_key")

        value = d.pop("value")

        custom_field_options_update_request_body = cls(
            sort_key=sort_key,
            value=value,
        )

        custom_field_options_update_request_body.additional_properties = d
        return custom_field_options_update_request_body

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
