"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const util_1 = require("../lib/util");
test('findUp', () => {
    // Starting at process.cwd()
    expect(util_1.findUp('README.md')).toMatch(/aws-lambda-nodejs$/);
    // Non existing file
    expect(util_1.findUp('non-existing-file.unknown')).toBe(undefined);
    // Starting at a specific path
    expect(util_1.findUp('util.test.ts', path.join(__dirname, 'integ-handlers'))).toMatch(/aws-lambda-nodejs\/test$/);
    // Non existing file starting at a non existing relative path
    expect(util_1.findUp('not-to-be-found.txt', 'non-existing/relative/path')).toBe(undefined);
    // Starting at a relative path
    expect(util_1.findUp('util.test.ts', 'test/integ-handlers')).toMatch(/aws-lambda-nodejs\/test$/);
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC50ZXN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidXRpbC50ZXN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsNkJBQTZCO0FBQzdCLHNDQUFxQztBQUVyQyxJQUFJLENBQUMsUUFBUSxFQUFFLEdBQUcsRUFBRTtJQUNsQiw0QkFBNEI7SUFDNUIsTUFBTSxDQUFDLGFBQU0sQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBRTFELG9CQUFvQjtJQUNwQixNQUFNLENBQUMsYUFBTSxDQUFDLDJCQUEyQixDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUM7SUFFNUQsOEJBQThCO0lBQzlCLE1BQU0sQ0FBQyxhQUFNLENBQUMsY0FBYyxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO0lBRTNHLDZEQUE2RDtJQUM3RCxNQUFNLENBQUMsYUFBTSxDQUFDLHFCQUFxQixFQUFFLDRCQUE0QixDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUM7SUFFcEYsOEJBQThCO0lBQzlCLE1BQU0sQ0FBQyxhQUFNLENBQUMsY0FBYyxFQUFFLHFCQUFxQixDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsMEJBQTBCLENBQUMsQ0FBQztBQUM1RixDQUFDLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgeyBmaW5kVXAgfSBmcm9tICcuLi9saWIvdXRpbCc7XG5cbnRlc3QoJ2ZpbmRVcCcsICgpID0+IHtcbiAgLy8gU3RhcnRpbmcgYXQgcHJvY2Vzcy5jd2QoKVxuICBleHBlY3QoZmluZFVwKCdSRUFETUUubWQnKSkudG9NYXRjaCgvYXdzLWxhbWJkYS1ub2RlanMkLyk7XG5cbiAgLy8gTm9uIGV4aXN0aW5nIGZpbGVcbiAgZXhwZWN0KGZpbmRVcCgnbm9uLWV4aXN0aW5nLWZpbGUudW5rbm93bicpKS50b0JlKHVuZGVmaW5lZCk7XG5cbiAgLy8gU3RhcnRpbmcgYXQgYSBzcGVjaWZpYyBwYXRoXG4gIGV4cGVjdChmaW5kVXAoJ3V0aWwudGVzdC50cycsIHBhdGguam9pbihfX2Rpcm5hbWUsICdpbnRlZy1oYW5kbGVycycpKSkudG9NYXRjaCgvYXdzLWxhbWJkYS1ub2RlanNcXC90ZXN0JC8pO1xuXG4gIC8vIE5vbiBleGlzdGluZyBmaWxlIHN0YXJ0aW5nIGF0IGEgbm9uIGV4aXN0aW5nIHJlbGF0aXZlIHBhdGhcbiAgZXhwZWN0KGZpbmRVcCgnbm90LXRvLWJlLWZvdW5kLnR4dCcsICdub24tZXhpc3RpbmcvcmVsYXRpdmUvcGF0aCcpKS50b0JlKHVuZGVmaW5lZCk7XG5cbiAgLy8gU3RhcnRpbmcgYXQgYSByZWxhdGl2ZSBwYXRoXG4gIGV4cGVjdChmaW5kVXAoJ3V0aWwudGVzdC50cycsICd0ZXN0L2ludGVnLWhhbmRsZXJzJykpLnRvTWF0Y2goL2F3cy1sYW1iZGEtbm9kZWpzXFwvdGVzdCQvKTtcbn0pO1xuIl19