"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const path = require("path");
const lambda = require("../lib");
class TestStack extends core_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        // This function uses aws-sdk but it will not be included
        new lambda.NodejsFunction(this, 'external', {
            entry: path.join(__dirname, 'integ-handlers/dependencies.ts'),
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            minify: true,
            // Will be installed, not bundled
            // (delay is a zero dependency package and its version is fixed
            // in the package.json to ensure a stable hash for this integ test)
            nodeModules: ['delay'],
        });
    }
}
const app = new core_1.App();
new TestStack(app, 'cdk-integ-lambda-nodejs-dependencies');
app.synth();
//# sourceMappingURL=data:application/json;base64,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