define ([
    'require'
    , 'nbextensions/visualpython/src/common/StringBuilder'
], function(requirejs, sb) {
    "use strict";

    // var sbCode = new sb.StringBuilder();

    /**
     * @class PythonComCodeGenerator
     * @constructor
    */
    var PythonComCodeGenerator = function() {
        this.sbCode = new sb.StringBuilder();
        this.pythonComStateGenerator;
    };

    /** 자식 클래스에서 반드시! 오버라이드 되는 메소드
     *  Python Common 패키지에서 코드 실행을 버튼을 누르면 생성하는 함수.
     */
    PythonComCodeGenerator.prototype.makeCode = function() {

    }

    PythonComCodeGenerator.prototype.getSbCode = function() {
        return this.sbCode; 
    }

    /** FIXME: 보류
     *  코드 생성 맨 앞 라인에
     * # Auto-Generated by VisualPython 주석을 생성한다
     */
    PythonComCodeGenerator.prototype._makePreVisualPythonComment = function() {
        // this.sbCode.appendLine(`# Auto-Generated by VisualPython`);
    }

    /**
    * mapFuncIdToFuncData api 함수에서 사용
    * PythonComStateGenerator 인스턴스를 가지고 있기 위해 사용하는 메소드
    * @override
    * @param {PythonComStateGenerator instance} pythonComStateGenerator 
    */
    PythonComCodeGenerator.prototype.setStateGenerator = function(pythonComStateGenerator) {
        this.pythonComStateGenerator = pythonComStateGenerator;
    }
    PythonComCodeGenerator.prototype.getStateGenerator = function() {
        return this.pythonComStateGenerator;
    }
    /**
     * 현재 sbCode에 저장된 코드를 보여주고 삭제하는 함수
     */
    PythonComCodeGenerator.prototype.getCodeAndClear = function() {
        var returnStr = this.sbCode.toString();
        this.sbCode.clear();
        return returnStr;
    }

    /**
     * IndentSpace 숫자 계산해서 ` ` 코드 띄어쓰기 갯수를 생성하는 함수
     * @param {number} indentSpaceNum 
     */
    PythonComCodeGenerator.prototype._makeIndentSpace = function(indentSpaceNum) {
        var indentStr = ``;
        while (indentSpaceNum > 0) {
            indentStr += ` `;
            indentSpaceNum--;
        }
        return indentStr;
    }

    PythonComCodeGenerator.prototype._mapOneArrayToCodeStr = function(paramList) {
        var paramStr = `(`;
        paramList.forEach(function(element, index) {
            if(index === paramList.length - 1){
                paramStr += `${element}`;
            } else {
                paramStr += `${element},`;
            }
        }); 
        paramStr += `)`;
        return paramStr;
    }

    /**
     * class for while if 등 여러개 라인의 코드를 한 번에 생성할 때,
     * 라인 별 IndentSpace를 생성해주는 함수
     * @param {Array<codeLine>} codeLineArray 
     * @param {number} indentSpaceNum 
     * @param {number} index 
     */
    PythonComCodeGenerator.prototype._calculateCodeLineIndentSpace = function(codeLineArray, indentSpaceNumStack, indentSpaceNum, index) {
        var isPrevIndex = index - 1 > -1 ? true : false;

        if (isPrevIndex === true){
            var isFinish = false;
            if(codeLineArray[index].type === "DEF") {
                var i = index;
                while(i-- !== 0){
                    if(codeLineArray[i].type === "CLASS"){
                        indentSpaceNum = indentSpaceNumStack[i] + 4;
                        isFinish = true;
                        break;
                    }
                }
            } 

            if(isFinish === false) {
                if((codeLineArray[index - 1].type !== "CLASS" || codeLineArray[index - 1].type !== "DEF")
                    && codeLineArray[index].type === "DEF" ){
                    indentSpaceNum -= 4;
                }  else if((codeLineArray[index - 1].type === "MAKE_VARIABLE" || codeLineArray[index - 1].type === "" )
                        && (codeLineArray[index].type === "ELSE" || codeLineArray[index].type === "ELIF")) {
                    indentSpaceNum -= 4;
                }  else if (
                    codeLineArray[index - 1].type === "CLASS" || codeLineArray[index - 1].type === "DEF" 
                    || codeLineArray[index - 1].type === "IF" 
                    || codeLineArray[index - 1].type === "FOR" || codeLineArray[index - 1].type === "WHILE"
                    || codeLineArray[index - 1].type === "ELSE" || codeLineArray[index - 1].type === "ELIF") {
                    indentSpaceNum += 4;
                }  else if (codeLineArray[index - 1].type === "BREAK" || codeLineArray[index - 1].type === "CONTINUE"  
                    || codeLineArray[index - 1].type === "RETURN") {
                    indentSpaceNum -= 4;
                } 
            }

            indentSpaceNumStack.push(indentSpaceNum);
        }
        return indentSpaceNum;
    }

    /** 
     * 리턴 변수가 있는지 없는지 확인하는 함수
     * @private
            @param {string | null} returnVarOrNull 
    */
    PythonComCodeGenerator.prototype._validateReturnVar = function(returnVarOrNull) {
        if (returnVarOrNull === null || returnVarOrNull === "") {
            returnVarOrNull = "";
        } else {
            returnVarOrNull += " = ";
        }
        return returnVarOrNull;
    }

    /** 
     * 리턴 변수를 프린트 하는 함수
     * @private
            @param {string} returnVar 
    */
    PythonComCodeGenerator.prototype._appendPrintReturnVar = function(returnVar) {
        var sbCode = this.getSbCode();
        sbCode.appendFormat(`{0}`, `${returnVar}`)
    }
    return PythonComCodeGenerator;
});
