# coding: utf-8

"""
    Selling Partner API for Finances

    The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class FBALiquidationEvent(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'posted_date': 'ModelDate',
        'original_removal_order_id': 'str',
        'liquidation_proceeds_amount': 'Currency',
        'liquidation_fee_amount': 'Currency'
    }

    attribute_map = {
        'posted_date': 'PostedDate',
        'original_removal_order_id': 'OriginalRemovalOrderId',
        'liquidation_proceeds_amount': 'LiquidationProceedsAmount',
        'liquidation_fee_amount': 'LiquidationFeeAmount'
    }

    def __init__(self, posted_date=None, original_removal_order_id=None, liquidation_proceeds_amount=None, liquidation_fee_amount=None):  # noqa: E501
        """FBALiquidationEvent - a model defined in Swagger"""  # noqa: E501
        self._posted_date = None
        self._original_removal_order_id = None
        self._liquidation_proceeds_amount = None
        self._liquidation_fee_amount = None
        self.discriminator = None
        if posted_date is not None:
            self.posted_date = posted_date
        if original_removal_order_id is not None:
            self.original_removal_order_id = original_removal_order_id
        if liquidation_proceeds_amount is not None:
            self.liquidation_proceeds_amount = liquidation_proceeds_amount
        if liquidation_fee_amount is not None:
            self.liquidation_fee_amount = liquidation_fee_amount

    @property
    def posted_date(self):
        """Gets the posted_date of this FBALiquidationEvent.  # noqa: E501


        :return: The posted_date of this FBALiquidationEvent.  # noqa: E501
        :rtype: ModelDate
        """
        return self._posted_date

    @posted_date.setter
    def posted_date(self, posted_date):
        """Sets the posted_date of this FBALiquidationEvent.


        :param posted_date: The posted_date of this FBALiquidationEvent.  # noqa: E501
        :type: ModelDate
        """

        self._posted_date = posted_date

    @property
    def original_removal_order_id(self):
        """Gets the original_removal_order_id of this FBALiquidationEvent.  # noqa: E501

        The identifier for the original removal order.  # noqa: E501

        :return: The original_removal_order_id of this FBALiquidationEvent.  # noqa: E501
        :rtype: str
        """
        return self._original_removal_order_id

    @original_removal_order_id.setter
    def original_removal_order_id(self, original_removal_order_id):
        """Sets the original_removal_order_id of this FBALiquidationEvent.

        The identifier for the original removal order.  # noqa: E501

        :param original_removal_order_id: The original_removal_order_id of this FBALiquidationEvent.  # noqa: E501
        :type: str
        """

        self._original_removal_order_id = original_removal_order_id

    @property
    def liquidation_proceeds_amount(self):
        """Gets the liquidation_proceeds_amount of this FBALiquidationEvent.  # noqa: E501


        :return: The liquidation_proceeds_amount of this FBALiquidationEvent.  # noqa: E501
        :rtype: Currency
        """
        return self._liquidation_proceeds_amount

    @liquidation_proceeds_amount.setter
    def liquidation_proceeds_amount(self, liquidation_proceeds_amount):
        """Sets the liquidation_proceeds_amount of this FBALiquidationEvent.


        :param liquidation_proceeds_amount: The liquidation_proceeds_amount of this FBALiquidationEvent.  # noqa: E501
        :type: Currency
        """

        self._liquidation_proceeds_amount = liquidation_proceeds_amount

    @property
    def liquidation_fee_amount(self):
        """Gets the liquidation_fee_amount of this FBALiquidationEvent.  # noqa: E501


        :return: The liquidation_fee_amount of this FBALiquidationEvent.  # noqa: E501
        :rtype: Currency
        """
        return self._liquidation_fee_amount

    @liquidation_fee_amount.setter
    def liquidation_fee_amount(self, liquidation_fee_amount):
        """Sets the liquidation_fee_amount of this FBALiquidationEvent.


        :param liquidation_fee_amount: The liquidation_fee_amount of this FBALiquidationEvent.  # noqa: E501
        :type: Currency
        """

        self._liquidation_fee_amount = liquidation_fee_amount

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(FBALiquidationEvent, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FBALiquidationEvent):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
