# coding: utf-8

"""
    Selling Partner API for Finances

    The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class PayWithAmazonEvent(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'seller_order_id': 'str',
        'transaction_posted_date': 'ModelDate',
        'business_object_type': 'str',
        'sales_channel': 'str',
        'charge': 'ChargeComponent',
        'fee_list': 'FeeComponentList',
        'payment_amount_type': 'str',
        'amount_description': 'str',
        'fulfillment_channel': 'str',
        'store_name': 'str'
    }

    attribute_map = {
        'seller_order_id': 'SellerOrderId',
        'transaction_posted_date': 'TransactionPostedDate',
        'business_object_type': 'BusinessObjectType',
        'sales_channel': 'SalesChannel',
        'charge': 'Charge',
        'fee_list': 'FeeList',
        'payment_amount_type': 'PaymentAmountType',
        'amount_description': 'AmountDescription',
        'fulfillment_channel': 'FulfillmentChannel',
        'store_name': 'StoreName'
    }

    def __init__(self, seller_order_id=None, transaction_posted_date=None, business_object_type=None, sales_channel=None, charge=None, fee_list=None, payment_amount_type=None, amount_description=None, fulfillment_channel=None, store_name=None):  # noqa: E501
        """PayWithAmazonEvent - a model defined in Swagger"""  # noqa: E501
        self._seller_order_id = None
        self._transaction_posted_date = None
        self._business_object_type = None
        self._sales_channel = None
        self._charge = None
        self._fee_list = None
        self._payment_amount_type = None
        self._amount_description = None
        self._fulfillment_channel = None
        self._store_name = None
        self.discriminator = None
        if seller_order_id is not None:
            self.seller_order_id = seller_order_id
        if transaction_posted_date is not None:
            self.transaction_posted_date = transaction_posted_date
        if business_object_type is not None:
            self.business_object_type = business_object_type
        if sales_channel is not None:
            self.sales_channel = sales_channel
        if charge is not None:
            self.charge = charge
        if fee_list is not None:
            self.fee_list = fee_list
        if payment_amount_type is not None:
            self.payment_amount_type = payment_amount_type
        if amount_description is not None:
            self.amount_description = amount_description
        if fulfillment_channel is not None:
            self.fulfillment_channel = fulfillment_channel
        if store_name is not None:
            self.store_name = store_name

    @property
    def seller_order_id(self):
        """Gets the seller_order_id of this PayWithAmazonEvent.  # noqa: E501

        An order identifier that is specified by the seller.  # noqa: E501

        :return: The seller_order_id of this PayWithAmazonEvent.  # noqa: E501
        :rtype: str
        """
        return self._seller_order_id

    @seller_order_id.setter
    def seller_order_id(self, seller_order_id):
        """Sets the seller_order_id of this PayWithAmazonEvent.

        An order identifier that is specified by the seller.  # noqa: E501

        :param seller_order_id: The seller_order_id of this PayWithAmazonEvent.  # noqa: E501
        :type: str
        """

        self._seller_order_id = seller_order_id

    @property
    def transaction_posted_date(self):
        """Gets the transaction_posted_date of this PayWithAmazonEvent.  # noqa: E501


        :return: The transaction_posted_date of this PayWithAmazonEvent.  # noqa: E501
        :rtype: ModelDate
        """
        return self._transaction_posted_date

    @transaction_posted_date.setter
    def transaction_posted_date(self, transaction_posted_date):
        """Sets the transaction_posted_date of this PayWithAmazonEvent.


        :param transaction_posted_date: The transaction_posted_date of this PayWithAmazonEvent.  # noqa: E501
        :type: ModelDate
        """

        self._transaction_posted_date = transaction_posted_date

    @property
    def business_object_type(self):
        """Gets the business_object_type of this PayWithAmazonEvent.  # noqa: E501

        The type of business object.  # noqa: E501

        :return: The business_object_type of this PayWithAmazonEvent.  # noqa: E501
        :rtype: str
        """
        return self._business_object_type

    @business_object_type.setter
    def business_object_type(self, business_object_type):
        """Sets the business_object_type of this PayWithAmazonEvent.

        The type of business object.  # noqa: E501

        :param business_object_type: The business_object_type of this PayWithAmazonEvent.  # noqa: E501
        :type: str
        """

        self._business_object_type = business_object_type

    @property
    def sales_channel(self):
        """Gets the sales_channel of this PayWithAmazonEvent.  # noqa: E501

        The sales channel for the transaction.  # noqa: E501

        :return: The sales_channel of this PayWithAmazonEvent.  # noqa: E501
        :rtype: str
        """
        return self._sales_channel

    @sales_channel.setter
    def sales_channel(self, sales_channel):
        """Sets the sales_channel of this PayWithAmazonEvent.

        The sales channel for the transaction.  # noqa: E501

        :param sales_channel: The sales_channel of this PayWithAmazonEvent.  # noqa: E501
        :type: str
        """

        self._sales_channel = sales_channel

    @property
    def charge(self):
        """Gets the charge of this PayWithAmazonEvent.  # noqa: E501


        :return: The charge of this PayWithAmazonEvent.  # noqa: E501
        :rtype: ChargeComponent
        """
        return self._charge

    @charge.setter
    def charge(self, charge):
        """Sets the charge of this PayWithAmazonEvent.


        :param charge: The charge of this PayWithAmazonEvent.  # noqa: E501
        :type: ChargeComponent
        """

        self._charge = charge

    @property
    def fee_list(self):
        """Gets the fee_list of this PayWithAmazonEvent.  # noqa: E501


        :return: The fee_list of this PayWithAmazonEvent.  # noqa: E501
        :rtype: FeeComponentList
        """
        return self._fee_list

    @fee_list.setter
    def fee_list(self, fee_list):
        """Sets the fee_list of this PayWithAmazonEvent.


        :param fee_list: The fee_list of this PayWithAmazonEvent.  # noqa: E501
        :type: FeeComponentList
        """

        self._fee_list = fee_list

    @property
    def payment_amount_type(self):
        """Gets the payment_amount_type of this PayWithAmazonEvent.  # noqa: E501

        The type of payment.  Possible values:  * Sales  # noqa: E501

        :return: The payment_amount_type of this PayWithAmazonEvent.  # noqa: E501
        :rtype: str
        """
        return self._payment_amount_type

    @payment_amount_type.setter
    def payment_amount_type(self, payment_amount_type):
        """Sets the payment_amount_type of this PayWithAmazonEvent.

        The type of payment.  Possible values:  * Sales  # noqa: E501

        :param payment_amount_type: The payment_amount_type of this PayWithAmazonEvent.  # noqa: E501
        :type: str
        """

        self._payment_amount_type = payment_amount_type

    @property
    def amount_description(self):
        """Gets the amount_description of this PayWithAmazonEvent.  # noqa: E501

        A short description of this payment event.  # noqa: E501

        :return: The amount_description of this PayWithAmazonEvent.  # noqa: E501
        :rtype: str
        """
        return self._amount_description

    @amount_description.setter
    def amount_description(self, amount_description):
        """Sets the amount_description of this PayWithAmazonEvent.

        A short description of this payment event.  # noqa: E501

        :param amount_description: The amount_description of this PayWithAmazonEvent.  # noqa: E501
        :type: str
        """

        self._amount_description = amount_description

    @property
    def fulfillment_channel(self):
        """Gets the fulfillment_channel of this PayWithAmazonEvent.  # noqa: E501

        The fulfillment channel.  Possible values:  * AFN - Amazon Fulfillment Network (Fulfillment by Amazon)  * MFN - Merchant Fulfillment Network (self-fulfilled)  # noqa: E501

        :return: The fulfillment_channel of this PayWithAmazonEvent.  # noqa: E501
        :rtype: str
        """
        return self._fulfillment_channel

    @fulfillment_channel.setter
    def fulfillment_channel(self, fulfillment_channel):
        """Sets the fulfillment_channel of this PayWithAmazonEvent.

        The fulfillment channel.  Possible values:  * AFN - Amazon Fulfillment Network (Fulfillment by Amazon)  * MFN - Merchant Fulfillment Network (self-fulfilled)  # noqa: E501

        :param fulfillment_channel: The fulfillment_channel of this PayWithAmazonEvent.  # noqa: E501
        :type: str
        """

        self._fulfillment_channel = fulfillment_channel

    @property
    def store_name(self):
        """Gets the store_name of this PayWithAmazonEvent.  # noqa: E501

        The store name where the event occurred.  # noqa: E501

        :return: The store_name of this PayWithAmazonEvent.  # noqa: E501
        :rtype: str
        """
        return self._store_name

    @store_name.setter
    def store_name(self, store_name):
        """Sets the store_name of this PayWithAmazonEvent.

        The store name where the event occurred.  # noqa: E501

        :param store_name: The store_name of this PayWithAmazonEvent.  # noqa: E501
        :type: str
        """

        self._store_name = store_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PayWithAmazonEvent, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PayWithAmazonEvent):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
