 # EllucianEthosPythonClient

[![PyPI version](https://badge.fury.io/py/EllucianEthosPythonClient.svg)](https://badge.fury.io/py/EllucianEthosPythonClient)

Python Client Library for interfacing with Ellucian Ethos.

 ## Aims

This library can:

 - Handle Ethos authorizations (JWT token etc.)
 - Create, update, and delete resources
 - Query resources individually and in groups
 - Fetch change notification from Ethos
 - Provide helper methods for spercific resource types 
 
 ## Usage examples

 - For a quick start usage example using the python REPL console follow the [Quickstart](./docs/QUICKSTART.md) guide.
 - For examples of getting mutiple resources see [Resource Iterator Guide](./docs/RESOURCEITERATORS.md)
 - For examples of using the poller functionality see [Poller Guide](./docs/POLLERGUIDE.md)
 - Examples of direclty calling Ethos API see [Direct Call](./docs/DIRECTCALL.md)
 - For sample scripts see [Sample scripts directory](./samples)

 ## Background

I started putting this python library after an Ethos user group meeting. There are a number of other Ellucian customers
all writing clients and I wanted to take the opportunity of digging out exmaples I had written for myself and my team
and sharing them with the community. I hope that publishing this library is useful to other Ethos users and hope to 
collaborate on improving it further. Please feel free to submit feedback, issues and pull requests.
  
 

