"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EdgeRole = void 0;
const aws_iam_1 = require("@aws-cdk/aws-iam");
const base_edge_construct_1 = require("./base-edge-construct");
class EdgeRole extends base_edge_construct_1.BaseEdgeConstruct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.role = new aws_iam_1.Role(this.edgeStack, id, {
            assumedBy: new aws_iam_1.CompositePrincipal(new aws_iam_1.ServicePrincipal('edgelambda.amazonaws.com'), new aws_iam_1.ServicePrincipal('lambda.amazonaws.com')),
            managedPolicies: [
                aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
            ],
            ...props,
        });
    }
    addToEdgeRolePolicy(statement) {
        this.role.addToPolicy(statement);
    }
}
exports.EdgeRole = EdgeRole;
//# sourceMappingURL=data:application/json;base64,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