import { Construct } from '@aws-cdk/core';
import { Code, IVersion } from '@aws-cdk/aws-lambda';
import { LambdaEdgeEventType } from '@aws-cdk/aws-cloudfront';
import { BaseEdgeConstruct } from './base-edge-construct';
import { Configuration } from './with-configuration';
import { IEdgeRole } from './edge-role';
import { ILambdaFunctionAssociation } from './lambda-function-association';
import { IEdgeLambda } from './edge-lambda';
export interface CommonEdgeFunctionProps {
    /**
     * The name of the parameter.
     */
    readonly parameterName?: string;
    readonly edgeRole?: IEdgeRole;
}
export interface EdgeFunctionProps extends CommonEdgeFunctionProps {
    readonly configuration: Configuration;
    readonly code: Code;
    readonly name: string;
    readonly eventType: LambdaEdgeEventType;
}
export declare class EdgeFunction extends BaseEdgeConstruct implements ILambdaFunctionAssociation, IEdgeLambda {
    readonly edgeRole: IEdgeRole;
    readonly eventType: LambdaEdgeEventType;
    readonly functionVersion: IVersion;
    readonly lambdaFunction: IVersion;
    constructor(scope: Construct, id: string, props: EdgeFunctionProps);
}
