### Set the stage

There many ways to deploy applications and create infrastructure now.

Astrobase was made to streamline how developers deliver containerized applications to Kubernetes environments on many cloud providers.

### Why?

First of all, B2B software deployments accelerate revenue generation for SaaS companies.

Astrobase's focus on maintaining one UX across cloud providers can accelerate deployments and increase team's effectiveness by letting them focus on building cool apps that add value to product, instead of building the tooling that gets them there.

Secondly, teams shouldn't have to spend time and energy learning entire systems, languages, and platforms to get there. Users should be able to write whatever code they want, as little as they need, and have a seamless, secure experience when creating environments to run their software.

### Alternatives

#### Pulumi

Pulumi is a great tool, and has many many features. Astrobase focuses on creating Kubernetes envrionments only to streamline and direct software delivery without a lot of bloat. Developers who enjoy software that does one thing well will appreciate Astrobase for it's simple nature and design.

#### Porter

Porter is a great tool for building multi cloud Kuberentes. However, it's license isn't very friendly and we think it's harder to automate than Astrobase. Astrobase's open-core, friendly license, and automated nature means it can be deployed and run anywhere you can install and run python (or docker).

#### Dapr

Dapr is a great solution for building distributed systems. Like Pulumi, Dapr has a huge feature set. Astrobase is for teams who just want a simple way to create and manage kubernetes clusters on any cloud.

#### Terraform

Terraform is a great tool for teams that need to manage complex, massive infrastructure systems. When you need something simpler, and integrates seamlessly with the code you're writing, we think it's worth your time writing 10 lines of code and using Astrobase over spending hours learning HCL.

#### Heroku

Heroku is great for teams who need to get their applications deployed and don't really care much about kubernetes. Astrobase is for teams who want to run their code across many clouds, you should probably just use Heroku if you are 100% sure you'll never have to deploy your applications to another cloud.
