"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WithConfiguration = exports.LogLevel = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
var LogLevel;
(function (LogLevel) {
    LogLevel["NONE"] = "none";
    LogLevel["INFO"] = "info";
    LogLevel["WARN"] = "warn";
    LogLevel["ERROR"] = "error";
    LogLevel["DEBUG"] = "debug";
})(LogLevel = exports.LogLevel || (exports.LogLevel = {}));
class WithConfiguration extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const resourceType = 'Custom::WithConfiguration';
        const handler = new aws_lambda_1.SingletonFunction(this, 'Handler', {
            uuid: 'cloudcomponents-cdk-lambda-at-edge-pattern-with-configuration',
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'with-configuration')),
            handler: 'index.handler',
            lambdaPurpose: resourceType,
            timeout: core_1.Duration.minutes(5),
        });
        handler.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['lambda:GetFunction', 'lambda:UpdateFunctionCode'],
            resources: [props.function.functionArn],
        }));
        const cr = new core_1.CustomResource(this, 'WithConfiguration', {
            serviceToken: handler.functionArn,
            resourceType,
            properties: {
                Region: 'us-east-1',
                FunctionName: props.function.functionName,
                Configuration: JSON.stringify(props.configuration, null, 2),
            },
        });
        this.functionVersion = aws_lambda_1.Version.fromVersionArn(this, 'Version', cr.getAttString('FunctionArn'));
    }
}
exports.WithConfiguration = WithConfiguration;
_a = JSII_RTTI_SYMBOL_1;
WithConfiguration[_a] = { fqn: "@cloudcomponents/cdk-lambda-at-edge-pattern.WithConfiguration", version: "1.30.0" };
//# sourceMappingURL=data:application/json;base64,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