# Generated by Django 2.2.6 on 2019-10-29 19:50

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import jsonfield.encoder
import jsonfield.fields
import trionyx.trionyx.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0011_update_proxy_permissions'),
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('deleted', models.BooleanField(default=False, verbose_name='Deleted')),
                ('verbose_name', models.TextField(blank=True, default='', verbose_name='Verbose name')),
                ('email', models.EmailField(max_length=255, unique=True, verbose_name='Email')),
                ('first_name', models.CharField(blank=True, default='', max_length=64, verbose_name='First name')),
                ('last_name', models.CharField(blank=True, default='', max_length=64, verbose_name='Last name')),
                ('is_active', models.BooleanField(default=True, verbose_name='Active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='Date joined')),
                ('last_online', models.DateTimeField(blank=True, null=True, verbose_name='Last online')),
                ('avatar', models.ImageField(blank=True, default='', upload_to='avatars/', verbose_name='Avatar')),
                ('language', models.CharField(choices=[('en-us', 'English'), ('nl', 'Dutch')], default=trionyx.trionyx.models.default_language, max_length=6, verbose_name='Language')),
                ('timezone', models.CharField(choices=[('Etc/GMT+12', 'Etc/GMT+12'), ('Etc/GMT+11', 'Etc/GMT+11'), ('Pacific/Midway', 'Pacific/Midway'), ('Pacific/Niue', 'Pacific/Niue'), ('Pacific/Pago_Pago', 'Pacific/Pago_Pago'), ('Etc/GMT+10', 'Etc/GMT+10'), ('Pacific/Honolulu', 'Pacific/Honolulu'), ('Pacific/Johnston', 'Pacific/Johnston'), ('Pacific/Rarotonga', 'Pacific/Rarotonga'), ('Pacific/Tahiti', 'Pacific/Tahiti'), ('America/Anchorage', 'America/Anchorage'), ('America/Juneau', 'America/Juneau'), ('America/Nome', 'America/Nome'), ('America/Sitka', 'America/Sitka'), ('America/Yakutat', 'America/Yakutat'), ('America/Santa_Isabel', 'America/Santa_Isabel'), ('America/Dawson', 'America/Dawson'), ('America/Los_Angeles', 'America/Los_Angeles'), ('America/Tijuana', 'America/Tijuana'), ('America/Vancouver', 'America/Vancouver'), ('America/Whitehorse', 'America/Whitehorse'), ('PST8PDT', 'PST8PDT'), ('America/Creston', 'America/Creston'), ('America/Dawson_Creek', 'America/Dawson_Creek'), ('America/Hermosillo', 'America/Hermosillo'), ('America/Phoenix', 'America/Phoenix'), ('Etc/GMT+7', 'Etc/GMT+7'), ('America/Chihuahua', 'America/Chihuahua'), ('America/Mazatlan', 'America/Mazatlan'), ('America/Boise', 'America/Boise'), ('America/Cambridge_Bay', 'America/Cambridge_Bay'), ('America/Denver', 'America/Denver'), ('America/Edmonton', 'America/Edmonton'), ('America/Inuvik', 'America/Inuvik'), ('America/Ojinaga', 'America/Ojinaga'), ('America/Yellowknife', 'America/Yellowknife'), ('MST7MDT', 'MST7MDT'), ('America/Belize', 'America/Belize'), ('America/Costa_Rica', 'America/Costa_Rica'), ('America/El_Salvador', 'America/El_Salvador'), ('America/Guatemala', 'America/Guatemala'), ('America/Managua', 'America/Managua'), ('America/Tegucigalpa', 'America/Tegucigalpa'), ('Etc/GMT+6', 'Etc/GMT+6'), ('Pacific/Galapagos', 'Pacific/Galapagos'), ('America/Chicago', 'America/Chicago'), ('America/Indiana/Knox', 'America/Indiana/Knox'), ('America/Indiana/Tell_City', 'America/Indiana/Tell_City'), ('America/Matamoros', 'America/Matamoros'), ('America/Menominee', 'America/Menominee'), ('America/North_Dakota/Beulah', 'America/North_Dakota/Beulah'), ('America/North_Dakota/Center', 'America/North_Dakota/Center'), ('America/North_Dakota/New_Salem', 'America/North_Dakota/New_Salem'), ('America/Rainy_River', 'America/Rainy_River'), ('America/Rankin_Inlet', 'America/Rankin_Inlet'), ('America/Resolute', 'America/Resolute'), ('America/Winnipeg', 'America/Winnipeg'), ('CST6CDT', 'CST6CDT'), ('America/Bahia_Banderas', 'America/Bahia_Banderas'), ('America/Cancun', 'America/Cancun'), ('America/Merida', 'America/Merida'), ('America/Mexico_City', 'America/Mexico_City'), ('America/Monterrey', 'America/Monterrey'), ('America/Regina', 'America/Regina'), ('America/Swift_Current', 'America/Swift_Current'), ('America/Bogota', 'America/Bogota'), ('America/Cayman', 'America/Cayman'), ('America/Coral_Harbour', 'America/Coral_Harbour'), ('America/Eirunepe', 'America/Eirunepe'), ('America/Guayaquil', 'America/Guayaquil'), ('America/Jamaica', 'America/Jamaica'), ('America/Lima', 'America/Lima'), ('America/Panama', 'America/Panama'), ('America/Rio_Branco', 'America/Rio_Branco'), ('Etc/GMT+5', 'Etc/GMT+5'), ('America/Detroit', 'America/Detroit'), ('America/Havana', 'America/Havana'), ('America/Indiana/Petersburg', 'America/Indiana/Petersburg'), ('America/Indiana/Vincennes', 'America/Indiana/Vincennes'), ('America/Indiana/Winamac', 'America/Indiana/Winamac'), ('America/Iqaluit', 'America/Iqaluit'), ('America/Kentucky/Monticello', 'America/Kentucky/Monticello'), ('America/Louisville', 'America/Louisville'), ('America/Montreal', 'America/Montreal'), ('America/Nassau', 'America/Nassau'), ('America/New_York', 'America/New_York'), ('America/Nipigon', 'America/Nipigon'), ('America/Pangnirtung', 'America/Pangnirtung'), ('America/Port-au-Prince', 'America/Port-au-Prince'), ('America/Thunder_Bay', 'America/Thunder_Bay'), ('America/Toronto', 'America/Toronto'), ('EST5EDT', 'EST5EDT'), ('America/Indiana/Marengo', 'America/Indiana/Marengo'), ('America/Indiana/Vevay', 'America/Indiana/Vevay'), ('America/Indianapolis', 'America/Indianapolis'), ('America/Caracas', 'America/Caracas'), ('America/Asuncion', 'America/Asuncion'), ('America/Glace_Bay', 'America/Glace_Bay'), ('America/Goose_Bay', 'America/Goose_Bay'), ('America/Halifax', 'America/Halifax'), ('America/Moncton', 'America/Moncton'), ('America/Thule', 'America/Thule'), ('Atlantic/Bermuda', 'Atlantic/Bermuda'), ('America/Campo_Grande', 'America/Campo_Grande'), ('America/Cuiaba', 'America/Cuiaba'), ('America/Anguilla', 'America/Anguilla'), ('America/Antigua', 'America/Antigua'), ('America/Aruba', 'America/Aruba'), ('America/Barbados', 'America/Barbados'), ('America/Blanc-Sablon', 'America/Blanc-Sablon'), ('America/Boa_Vista', 'America/Boa_Vista'), ('America/Curacao', 'America/Curacao'), ('America/Dominica', 'America/Dominica'), ('America/Grand_Turk', 'America/Grand_Turk'), ('America/Grenada', 'America/Grenada'), ('America/Guadeloupe', 'America/Guadeloupe'), ('America/Guyana', 'America/Guyana'), ('America/Kralendijk', 'America/Kralendijk'), ('America/La_Paz', 'America/La_Paz'), ('America/Lower_Princes', 'America/Lower_Princes'), ('America/Manaus', 'America/Manaus'), ('America/Marigot', 'America/Marigot'), ('America/Martinique', 'America/Martinique'), ('America/Montserrat', 'America/Montserrat'), ('America/Port_of_Spain', 'America/Port_of_Spain'), ('America/Porto_Velho', 'America/Porto_Velho'), ('America/Puerto_Rico', 'America/Puerto_Rico'), ('America/Santo_Domingo', 'America/Santo_Domingo'), ('America/St_Barthelemy', 'America/St_Barthelemy'), ('America/St_Kitts', 'America/St_Kitts'), ('America/St_Lucia', 'America/St_Lucia'), ('America/St_Thomas', 'America/St_Thomas'), ('America/St_Vincent', 'America/St_Vincent'), ('America/Tortola', 'America/Tortola'), ('Etc/GMT+4', 'Etc/GMT+4'), ('America/Santiago', 'America/Santiago'), ('Antarctica/Palmer', 'Antarctica/Palmer'), ('America/St_Johns', 'America/St_Johns'), ('America/Sao_Paulo', 'America/Sao_Paulo'), ('America/Argentina/La_Rioja', 'America/Argentina/La_Rioja'), ('America/Argentina/Rio_Gallegos', 'America/Argentina/Rio_Gallegos'), ('America/Argentina/Salta', 'America/Argentina/Salta'), ('America/Argentina/San_Juan', 'America/Argentina/San_Juan'), ('America/Argentina/San_Luis', 'America/Argentina/San_Luis'), ('America/Argentina/Tucuman', 'America/Argentina/Tucuman'), ('America/Argentina/Ushuaia', 'America/Argentina/Ushuaia'), ('America/Buenos_Aires', 'America/Buenos_Aires'), ('America/Catamarca', 'America/Catamarca'), ('America/Cordoba', 'America/Cordoba'), ('America/Jujuy', 'America/Jujuy'), ('America/Mendoza', 'America/Mendoza'), ('America/Araguaina', 'America/Araguaina'), ('America/Belem', 'America/Belem'), ('America/Cayenne', 'America/Cayenne'), ('America/Fortaleza', 'America/Fortaleza'), ('America/Maceio', 'America/Maceio'), ('America/Paramaribo', 'America/Paramaribo'), ('America/Recife', 'America/Recife'), ('America/Santarem', 'America/Santarem'), ('Antarctica/Rothera', 'Antarctica/Rothera'), ('Atlantic/Stanley', 'Atlantic/Stanley'), ('Etc/GMT+3', 'Etc/GMT+3'), ('America/Godthab', 'America/Godthab'), ('America/Montevideo', 'America/Montevideo'), ('America/Bahia', 'America/Bahia'), ('America/Noronha', 'America/Noronha'), ('Atlantic/South_Georgia', 'Atlantic/South_Georgia'), ('Etc/GMT+2', 'Etc/GMT+2'), ('America/Scoresbysund', 'America/Scoresbysund'), ('Atlantic/Azores', 'Atlantic/Azores'), ('Atlantic/Cape_Verde', 'Atlantic/Cape_Verde'), ('Etc/GMT+1', 'Etc/GMT+1'), ('Africa/Casablanca', 'Africa/Casablanca'), ('Africa/El_Aaiun', 'Africa/El_Aaiun'), ('America/Danmarkshavn', 'America/Danmarkshavn'), ('Etc/GMT', 'Etc/GMT'), ('Europe/Isle_of_Man', 'Europe/Isle_of_Man'), ('Europe/Guernsey', 'Europe/Guernsey'), ('Europe/Jersey', 'Europe/Jersey'), ('Europe/London', 'Europe/London'), ('Atlantic/Canary', 'Atlantic/Canary'), ('Atlantic/Faeroe', 'Atlantic/Faeroe'), ('Atlantic/Madeira', 'Atlantic/Madeira'), ('Europe/Dublin', 'Europe/Dublin'), ('Europe/Lisbon', 'Europe/Lisbon'), ('Africa/Abidjan', 'Africa/Abidjan'), ('Africa/Accra', 'Africa/Accra'), ('Africa/Bamako', 'Africa/Bamako'), ('Africa/Banjul', 'Africa/Banjul'), ('Africa/Bissau', 'Africa/Bissau'), ('Africa/Conakry', 'Africa/Conakry'), ('Africa/Dakar', 'Africa/Dakar'), ('Africa/Freetown', 'Africa/Freetown'), ('Africa/Lome', 'Africa/Lome'), ('Africa/Monrovia', 'Africa/Monrovia'), ('Africa/Nouakchott', 'Africa/Nouakchott'), ('Africa/Ouagadougou', 'Africa/Ouagadougou'), ('Africa/Sao_Tome', 'Africa/Sao_Tome'), ('Atlantic/Reykjavik', 'Atlantic/Reykjavik'), ('Atlantic/St_Helena', 'Atlantic/St_Helena'), ('Arctic/Longyearbyen', 'Arctic/Longyearbyen'), ('Europe/Amsterdam', 'Europe/Amsterdam'), ('Europe/Andorra', 'Europe/Andorra'), ('Europe/Berlin', 'Europe/Berlin'), ('Europe/Busingen', 'Europe/Busingen'), ('Europe/Gibraltar', 'Europe/Gibraltar'), ('Europe/Luxembourg', 'Europe/Luxembourg'), ('Europe/Malta', 'Europe/Malta'), ('Europe/Monaco', 'Europe/Monaco'), ('Europe/Oslo', 'Europe/Oslo'), ('Europe/Rome', 'Europe/Rome'), ('Europe/San_Marino', 'Europe/San_Marino'), ('Europe/Stockholm', 'Europe/Stockholm'), ('Europe/Vaduz', 'Europe/Vaduz'), ('Europe/Vatican', 'Europe/Vatican'), ('Europe/Vienna', 'Europe/Vienna'), ('Europe/Zurich', 'Europe/Zurich'), ('Europe/Belgrade', 'Europe/Belgrade'), ('Europe/Bratislava', 'Europe/Bratislava'), ('Europe/Budapest', 'Europe/Budapest'), ('Europe/Ljubljana', 'Europe/Ljubljana'), ('Europe/Podgorica', 'Europe/Podgorica'), ('Europe/Prague', 'Europe/Prague'), ('Europe/Tirane', 'Europe/Tirane'), ('Africa/Ceuta', 'Africa/Ceuta'), ('Europe/Brussels', 'Europe/Brussels'), ('Europe/Copenhagen', 'Europe/Copenhagen'), ('Europe/Madrid', 'Europe/Madrid'), ('Europe/Paris', 'Europe/Paris'), ('Europe/Sarajevo', 'Europe/Sarajevo'), ('Europe/Skopje', 'Europe/Skopje'), ('Europe/Warsaw', 'Europe/Warsaw'), ('Europe/Zagreb', 'Europe/Zagreb'), ('Africa/Algiers', 'Africa/Algiers'), ('Africa/Bangui', 'Africa/Bangui'), ('Africa/Brazzaville', 'Africa/Brazzaville'), ('Africa/Douala', 'Africa/Douala'), ('Africa/Kinshasa', 'Africa/Kinshasa'), ('Africa/Lagos', 'Africa/Lagos'), ('Africa/Libreville', 'Africa/Libreville'), ('Africa/Luanda', 'Africa/Luanda'), ('Africa/Malabo', 'Africa/Malabo'), ('Africa/Ndjamena', 'Africa/Ndjamena'), ('Africa/Niamey', 'Africa/Niamey'), ('Africa/Porto-Novo', 'Africa/Porto-Novo'), ('Africa/Tunis', 'Africa/Tunis'), ('Etc/GMT-1', 'Etc/GMT-1'), ('Africa/Windhoek', 'Africa/Windhoek'), ('Asia/Nicosia', 'Asia/Nicosia'), ('Europe/Athens', 'Europe/Athens'), ('Europe/Bucharest', 'Europe/Bucharest'), ('Europe/Chisinau', 'Europe/Chisinau'), ('Asia/Beirut', 'Asia/Beirut'), ('Africa/Cairo', 'Africa/Cairo'), ('Asia/Damascus', 'Asia/Damascus'), ('Europe/Helsinki', 'Europe/Helsinki'), ('Europe/Kiev', 'Europe/Kiev'), ('Europe/Mariehamn', 'Europe/Mariehamn'), ('Europe/Nicosia', 'Europe/Nicosia'), ('Europe/Riga', 'Europe/Riga'), ('Europe/Sofia', 'Europe/Sofia'), ('Europe/Tallinn', 'Europe/Tallinn'), ('Europe/Uzhgorod', 'Europe/Uzhgorod'), ('Europe/Vilnius', 'Europe/Vilnius'), ('Europe/Zaporozhye', 'Europe/Zaporozhye'), ('Africa/Blantyre', 'Africa/Blantyre'), ('Africa/Bujumbura', 'Africa/Bujumbura'), ('Africa/Gaborone', 'Africa/Gaborone'), ('Africa/Harare', 'Africa/Harare'), ('Africa/Johannesburg', 'Africa/Johannesburg'), ('Africa/Kigali', 'Africa/Kigali'), ('Africa/Lubumbashi', 'Africa/Lubumbashi'), ('Africa/Lusaka', 'Africa/Lusaka'), ('Africa/Maputo', 'Africa/Maputo'), ('Africa/Maseru', 'Africa/Maseru'), ('Africa/Mbabane', 'Africa/Mbabane'), ('Etc/GMT-2', 'Etc/GMT-2'), ('Europe/Istanbul', 'Europe/Istanbul'), ('Asia/Jerusalem', 'Asia/Jerusalem'), ('Africa/Tripoli', 'Africa/Tripoli'), ('Asia/Amman', 'Asia/Amman'), ('Asia/Baghdad', 'Asia/Baghdad'), ('Europe/Kaliningrad', 'Europe/Kaliningrad'), ('Europe/Minsk', 'Europe/Minsk'), ('Asia/Aden', 'Asia/Aden'), ('Asia/Bahrain', 'Asia/Bahrain'), ('Asia/Kuwait', 'Asia/Kuwait'), ('Asia/Qatar', 'Asia/Qatar'), ('Asia/Riyadh', 'Asia/Riyadh'), ('Africa/Addis_Ababa', 'Africa/Addis_Ababa'), ('Africa/Asmera', 'Africa/Asmera'), ('Africa/Dar_es_Salaam', 'Africa/Dar_es_Salaam'), ('Africa/Djibouti', 'Africa/Djibouti'), ('Africa/Juba', 'Africa/Juba'), ('Africa/Kampala', 'Africa/Kampala'), ('Africa/Khartoum', 'Africa/Khartoum'), ('Africa/Mogadishu', 'Africa/Mogadishu'), ('Africa/Nairobi', 'Africa/Nairobi'), ('Antarctica/Syowa', 'Antarctica/Syowa'), ('Etc/GMT-3', 'Etc/GMT-3'), ('Indian/Antananarivo', 'Indian/Antananarivo'), ('Indian/Comoro', 'Indian/Comoro'), ('Indian/Mayotte', 'Indian/Mayotte'), ('Europe/Kirov', 'Europe/Kirov'), ('Europe/Moscow', 'Europe/Moscow'), ('Europe/Simferopol', 'Europe/Simferopol'), ('Europe/Volgograd', 'Europe/Volgograd'), ('Europe/Astrakhan', 'Europe/Astrakhan'), ('Europe/Samara', 'Europe/Samara'), ('Europe/Ulyanovsk', 'Europe/Ulyanovsk'), ('Asia/Tehran', 'Asia/Tehran'), ('Asia/Dubai', 'Asia/Dubai'), ('Asia/Muscat', 'Asia/Muscat'), ('Etc/GMT-4', 'Etc/GMT-4'), ('Asia/Baku', 'Asia/Baku'), ('Indian/Mahe', 'Indian/Mahe'), ('Indian/Mauritius', 'Indian/Mauritius'), ('Indian/Reunion', 'Indian/Reunion'), ('Asia/Tbilisi', 'Asia/Tbilisi'), ('Asia/Yerevan', 'Asia/Yerevan'), ('Asia/Kabul', 'Asia/Kabul'), ('Antarctica/Mawson', 'Antarctica/Mawson'), ('Asia/Aqtau', 'Asia/Aqtau'), ('Asia/Aqtobe', 'Asia/Aqtobe'), ('Asia/Ashgabat', 'Asia/Ashgabat'), ('Asia/Dushanbe', 'Asia/Dushanbe'), ('Asia/Oral', 'Asia/Oral'), ('Asia/Samarkand', 'Asia/Samarkand'), ('Asia/Tashkent', 'Asia/Tashkent'), ('Etc/GMT-5', 'Etc/GMT-5'), ('Indian/Kerguelen', 'Indian/Kerguelen'), ('Indian/Maldives', 'Indian/Maldives'), ('Asia/Yekaterinburg', 'Asia/Yekaterinburg'), ('Asia/Karachi', 'Asia/Karachi'), ('Asia/Kolkata', 'Asia/Kolkata'), ('Asia/Colombo', 'Asia/Colombo'), ('Asia/Katmandu', 'Asia/Katmandu'), ('Antarctica/Vostok', 'Antarctica/Vostok'), ('Asia/Almaty', 'Asia/Almaty'), ('Asia/Bishkek', 'Asia/Bishkek'), ('Asia/Qyzylorda', 'Asia/Qyzylorda'), ('Asia/Urumqi', 'Asia/Urumqi'), ('Etc/GMT-6', 'Etc/GMT-6'), ('Indian/Chagos', 'Indian/Chagos'), ('Asia/Dhaka', 'Asia/Dhaka'), ('Asia/Thimphu', 'Asia/Thimphu'), ('Asia/Rangoon', 'Asia/Rangoon'), ('Indian/Cocos', 'Indian/Cocos'), ('Antarctica/Davis', 'Antarctica/Davis'), ('Asia/Bangkok', 'Asia/Bangkok'), ('Asia/Hovd', 'Asia/Hovd'), ('Asia/Jakarta', 'Asia/Jakarta'), ('Asia/Phnom_Penh', 'Asia/Phnom_Penh'), ('Asia/Pontianak', 'Asia/Pontianak'), ('Asia/Saigon', 'Asia/Saigon'), ('Asia/Vientiane', 'Asia/Vientiane'), ('Etc/GMT-7', 'Etc/GMT-7'), ('Indian/Christmas', 'Indian/Christmas'), ('Asia/Novokuznetsk', 'Asia/Novokuznetsk'), ('Asia/Novosibirsk', 'Asia/Novosibirsk'), ('Asia/Omsk', 'Asia/Omsk'), ('Asia/Hong_Kong', 'Asia/Hong_Kong'), ('Asia/Macau', 'Asia/Macau'), ('Asia/Shanghai', 'Asia/Shanghai'), ('Asia/Krasnoyarsk', 'Asia/Krasnoyarsk'), ('Asia/Brunei', 'Asia/Brunei'), ('Asia/Kuala_Lumpur', 'Asia/Kuala_Lumpur'), ('Asia/Kuching', 'Asia/Kuching'), ('Asia/Makassar', 'Asia/Makassar'), ('Asia/Manila', 'Asia/Manila'), ('Asia/Singapore', 'Asia/Singapore'), ('Etc/GMT-8', 'Etc/GMT-8'), ('Antarctica/Casey', 'Antarctica/Casey'), ('Australia/Perth', 'Australia/Perth'), ('Asia/Taipei', 'Asia/Taipei'), ('Asia/Choibalsan', 'Asia/Choibalsan'), ('Asia/Ulaanbaatar', 'Asia/Ulaanbaatar'), ('Asia/Irkutsk', 'Asia/Irkutsk'), ('Asia/Dili', 'Asia/Dili'), ('Asia/Jayapura', 'Asia/Jayapura'), ('Asia/Tokyo', 'Asia/Tokyo'), ('Etc/GMT-9', 'Etc/GMT-9'), ('Pacific/Palau', 'Pacific/Palau'), ('Asia/Pyongyang', 'Asia/Pyongyang'), ('Asia/Seoul', 'Asia/Seoul'), ('Australia/Adelaide', 'Australia/Adelaide'), ('Australia/Broken_Hill', 'Australia/Broken_Hill'), ('Australia/Darwin', 'Australia/Darwin'), ('Australia/Brisbane', 'Australia/Brisbane'), ('Australia/Lindeman', 'Australia/Lindeman'), ('Australia/Melbourne', 'Australia/Melbourne'), ('Australia/Sydney', 'Australia/Sydney'), ('Antarctica/DumontDUrville', 'Antarctica/DumontDUrville'), ('Etc/GMT-10', 'Etc/GMT-10'), ('Pacific/Guam', 'Pacific/Guam'), ('Pacific/Port_Moresby', 'Pacific/Port_Moresby'), ('Pacific/Saipan', 'Pacific/Saipan'), ('Pacific/Truk', 'Pacific/Truk'), ('Australia/Currie', 'Australia/Currie'), ('Australia/Hobart', 'Australia/Hobart'), ('Asia/Chita', 'Asia/Chita'), ('Asia/Khandyga', 'Asia/Khandyga'), ('Asia/Yakutsk', 'Asia/Yakutsk'), ('Antarctica/Macquarie', 'Antarctica/Macquarie'), ('Etc/GMT-11', 'Etc/GMT-11'), ('Pacific/Efate', 'Pacific/Efate'), ('Pacific/Guadalcanal', 'Pacific/Guadalcanal'), ('Pacific/Kosrae', 'Pacific/Kosrae'), ('Pacific/Noumea', 'Pacific/Noumea'), ('Pacific/Ponape', 'Pacific/Ponape'), ('Asia/Sakhalin', 'Asia/Sakhalin'), ('Asia/Ust-Nera', 'Asia/Ust-Nera'), ('Asia/Vladivostok', 'Asia/Vladivostok'), ('Antarctica/McMurdo', 'Antarctica/McMurdo'), ('Pacific/Auckland', 'Pacific/Auckland'), ('Etc/GMT-12', 'Etc/GMT-12'), ('Pacific/Funafuti', 'Pacific/Funafuti'), ('Pacific/Kwajalein', 'Pacific/Kwajalein'), ('Pacific/Majuro', 'Pacific/Majuro'), ('Pacific/Nauru', 'Pacific/Nauru'), ('Pacific/Tarawa', 'Pacific/Tarawa'), ('Pacific/Wake', 'Pacific/Wake'), ('Pacific/Wallis', 'Pacific/Wallis'), ('Pacific/Fiji', 'Pacific/Fiji'), ('Asia/Anadyr', 'Asia/Anadyr'), ('Asia/Kamchatka', 'Asia/Kamchatka'), ('Asia/Magadan', 'Asia/Magadan'), ('Asia/Srednekolymsk', 'Asia/Srednekolymsk'), ('Etc/GMT-13', 'Etc/GMT-13'), ('Pacific/Enderbury', 'Pacific/Enderbury'), ('Pacific/Fakaofo', 'Pacific/Fakaofo'), ('Pacific/Tongatapu', 'Pacific/Tongatapu'), ('Pacific/Apia', 'Pacific/Apia')], default=trionyx.trionyx.models.default_timezone, max_length=32, verbose_name='Timezone')),
                ('created_by', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='Created by')),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions')),
            ],
            options={
                'verbose_name': 'User',
                'verbose_name_plural': 'Users',
            },
        ),
        migrations.CreateModel(
            name='Log',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('deleted', models.BooleanField(default=False, verbose_name='Deleted')),
                ('verbose_name', models.TextField(blank=True, default='', verbose_name='Verbose name')),
                ('log_hash', models.CharField(max_length=32, verbose_name='Log hash')),
                ('level', models.IntegerField(choices=[(50, 'Critical'), (40, 'Error'), (30, 'Warning'), (20, 'Info'), (10, 'Debug'), (0, 'Not set')], verbose_name='Level')),
                ('message', models.TextField(verbose_name='Message')),
                ('file_path', models.CharField(max_length=256, verbose_name='File path')),
                ('file_line', models.IntegerField(verbose_name='File line')),
                ('traceback', models.TextField(default='', verbose_name='Traceback')),
                ('last_event', models.DateTimeField(verbose_name='Last event')),
                ('log_count', models.IntegerField(default=1, verbose_name='Log count')),
                ('created_by', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='Created by')),
            ],
            options={
                'verbose_name': 'Log',
                'verbose_name_plural': 'Logs',
            },
        ),
        migrations.CreateModel(
            name='Task',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('deleted', models.BooleanField(default=False, verbose_name='Deleted')),
                ('verbose_name', models.TextField(blank=True, default='', verbose_name='Verbose name')),
                ('celery_task_id', models.CharField(max_length=64, unique=True)),
                ('status', models.IntegerField(choices=[(10, 'Scheduled'), (20, 'Queue'), (30, 'Locked'), (40, 'Running'), (50, 'Completed'), (99, 'Failed')], default=20, verbose_name='Status')),
                ('identifier', models.CharField(default='not_set', max_length=255, verbose_name='Identifier')),
                ('description', models.TextField(default='', verbose_name='Description')),
                ('progress', models.PositiveIntegerField(default=0, verbose_name='Progress')),
                ('progress_output', jsonfield.fields.JSONField(default=list, dump_kwargs={'cls': jsonfield.encoder.JSONEncoder, 'separators': (',', ':')}, load_kwargs={}, verbose_name='Progress output')),
                ('scheduled_at', models.DateTimeField(blank=True, null=True, verbose_name='Scheduled at')),
                ('started_at', models.DateTimeField(blank=True, null=True, verbose_name='started at')),
                ('execution_time', models.IntegerField(default=0, verbose_name='Execution time')),
                ('result', models.TextField(blank=True, default='', verbose_name='Result')),
                ('object_id', models.BigIntegerField(blank=True, null=True, verbose_name='Object ID')),
                ('object_verbose_name', models.TextField(blank=True, default='', verbose_name='Object name')),
                ('created_by', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='Created by')),
                ('object_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='contenttypes.ContentType', verbose_name='Object type')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL, verbose_name='Started by')),
            ],
            options={
                'verbose_name': 'Task',
                'verbose_name_plural': 'Tasks',
            },
        ),
        migrations.CreateModel(
            name='LogEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('log_time', models.DateTimeField(verbose_name='Log time')),
                ('path', models.TextField(default='', verbose_name='Path')),
                ('user_agent', models.TextField(default='', verbose_name='User agent')),
                ('log', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='entries', to='trionyx.Log')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'verbose_name': 'Log entry',
                'verbose_name_plural': 'Log entries',
            },
        ),
        migrations.CreateModel(
            name='AuditLogEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('deleted', models.BooleanField(default=False, verbose_name='Deleted')),
                ('verbose_name', models.TextField(blank=True, default='', verbose_name='Verbose name')),
                ('object_id', models.BigIntegerField(blank=True, null=True)),
                ('object_verbose_name', models.TextField(blank=True, default='')),
                ('action', models.IntegerField(choices=[(10, 'Added'), (20, 'Changed'), (30, 'Deleted')])),
                ('changes', jsonfield.fields.JSONField(dump_kwargs={'cls': jsonfield.encoder.JSONEncoder, 'separators': (',', ':')}, load_kwargs={})),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='contenttypes.ContentType')),
                ('created_by', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='Created by')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='UserAttribute',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=128)),
                ('value', jsonfield.fields.JSONField(dump_kwargs={'cls': jsonfield.encoder.JSONEncoder, 'separators': (',', ':')}, load_kwargs={})),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='attributes', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'unique_together': {('user', 'code')},
            },
        ),
        migrations.AddIndex(
            model_name='auditlogentry',
            index=models.Index(fields=['content_type', 'object_id'], name='trionyx_aud_content_072d99_idx'),
        ),
    ]
