# mms-python-client
Documentation for MMS API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 4.0.0
- Package version: 4.0.0.b5
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [http://openmbee.org](http://openmbee.org)

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import mms_python_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import mms_python_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import mms_python_client
from pprint import pprint
from mms_python_client.api import artifacts_api
from mms_python_client.model.elements_response import ElementsResponse
# Defining the host is optional and defaults to http://localhost:8080
# See configuration.py for a list of all supported configuration parameters.
configuration = mms_python_client.Configuration(
    host = "http://localhost:8080"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basicAuth
configuration = mms_python_client.Configuration(
    username = 'YOUR_USERNAME',
    password = 'YOUR_PASSWORD'
)

# Configure Bearer authorization (JWT): bearerToken
configuration = mms_python_client.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with mms_python_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = artifacts_api.ArtifactsApi(api_client)
    project_id = "projectId_example" # str | 
ref_id = "refId_example" # str | 
element_id = "elementId_example" # str | 
file = open('/path/to/file', 'rb') # file_type |  (optional)

    try:
        api_response = api_instance.create_or_update_artifacts(project_id, ref_id, element_id, file=file)
        pprint(api_response)
    except mms_python_client.ApiException as e:
        print("Exception when calling ArtifactsApi->create_or_update_artifacts: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8080*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ArtifactsApi* | [**create_or_update_artifacts**](docs/ArtifactsApi.md#create_or_update_artifacts) | **POST** /projects/{projectId}/refs/{refId}/elements/{elementId} | 
*ArtifactsApi* | [**delete_artifact_by_extension**](docs/ArtifactsApi.md#delete_artifact_by_extension) | **DELETE** /projects/{projectId}/refs/{refId}/elements/{elementId}/{extension} | 
*ArtifactsApi* | [**get_artifact_by_extension**](docs/ArtifactsApi.md#get_artifact_by_extension) | **GET** /projects/{projectId}/refs/{refId}/elements/{elementId}/{extension} | 
*AuthApi* | [**check_authentication_token**](docs/AuthApi.md#check_authentication_token) | **GET** /checkAuth | 
*AuthApi* | [**create_authentication_token**](docs/AuthApi.md#create_authentication_token) | **POST** /authentication | 
*AuthApi* | [**create_user**](docs/AuthApi.md#create_user) | **POST** /user | 
*AuthApi* | [**get_authentication_token**](docs/AuthApi.md#get_authentication_token) | **GET** /authentication | 
*AuthApi* | [**get_branch_permissions**](docs/AuthApi.md#get_branch_permissions) | **GET** /projects/{projectId}/refs/{refId}/permissions | 
*AuthApi* | [**get_org_permissions**](docs/AuthApi.md#get_org_permissions) | **GET** /orgs/{orgId}/permissions | 
*AuthApi* | [**get_project_permissions**](docs/AuthApi.md#get_project_permissions) | **GET** /projects/{projectId}/permissions | 
*AuthApi* | [**get_users**](docs/AuthApi.md#get_users) | **GET** /users | 
*AuthApi* | [**lookup_permissions**](docs/AuthApi.md#lookup_permissions) | **PUT** /permissions | 
*AuthApi* | [**update_branch_permissions**](docs/AuthApi.md#update_branch_permissions) | **POST** /projects/{projectId}/refs/{refId}/permissions | 
*AuthApi* | [**update_org_permissions**](docs/AuthApi.md#update_org_permissions) | **POST** /orgs/{orgId}/permissions | 
*AuthApi* | [**update_password**](docs/AuthApi.md#update_password) | **POST** /password | 
*AuthApi* | [**update_project_permissions**](docs/AuthApi.md#update_project_permissions) | **POST** /projects/{projectId}/permissions | 
*CommitsApi* | [**get_commit**](docs/CommitsApi.md#get_commit) | **GET** /projects/{projectId}/commits/{commitId} | 
*CommitsApi* | [**get_commits**](docs/CommitsApi.md#get_commits) | **PUT** /projects/{projectId}/commits | 
*CommitsApi* | [**get_element_commits**](docs/CommitsApi.md#get_element_commits) | **GET** /projects/{projectId}/refs/{refId}/elements/{elementId}/commits | 
*CommitsApi* | [**get_ref_commits**](docs/CommitsApi.md#get_ref_commits) | **GET** /projects/{projectId}/refs/{refId}/commits | 
*ElementsApi* | [**create_or_update_elements**](docs/ElementsApi.md#create_or_update_elements) | **POST** /projects/{projectId}/refs/{refId}/elements | 
*ElementsApi* | [**delete_element**](docs/ElementsApi.md#delete_element) | **DELETE** /projects/{projectId}/refs/{refId}/elements/{elementId} | 
*ElementsApi* | [**delete_elements**](docs/ElementsApi.md#delete_elements) | **DELETE** /projects/{projectId}/refs/{refId}/elements | 
*ElementsApi* | [**get_all_elements**](docs/ElementsApi.md#get_all_elements) | **GET** /projects/{projectId}/refs/{refId}/elements | 
*ElementsApi* | [**get_artifact_for_element1**](docs/ElementsApi.md#get_artifact_for_element1) | **GET** /projects/{projectId}/refs/{refId}/elements/{elementId} | 
*ElementsApi* | [**get_elements**](docs/ElementsApi.md#get_elements) | **PUT** /projects/{projectId}/refs/{refId}/elements | 
*MMSVersionApi* | [**get_mms_version**](docs/MMSVersionApi.md#get_mms_version) | **GET** /mmsversion | 
*NotebooksApi* | [**create_or_update_notebooks**](docs/NotebooksApi.md#create_or_update_notebooks) | **POST** /projects/{projectId}/refs/{refId}/notebooks | 
*NotebooksApi* | [**get_all_notebooks**](docs/NotebooksApi.md#get_all_notebooks) | **GET** /projects/{projectId}/refs/{refId}/notebooks | 
*NotebooksApi* | [**get_notebook**](docs/NotebooksApi.md#get_notebook) | **GET** /projects/{projectId}/refs/{refId}/notebooks/{notebookId} | 
*NotebooksApi* | [**get_notebooks**](docs/NotebooksApi.md#get_notebooks) | **PUT** /projects/{projectId}/refs/{refId}/notebooks | 
*OrgsApi* | [**create_or_update_orgs**](docs/OrgsApi.md#create_or_update_orgs) | **POST** /orgs | 
*OrgsApi* | [**delete_org**](docs/OrgsApi.md#delete_org) | **DELETE** /orgs/{orgId} | 
*OrgsApi* | [**get_all_orgs**](docs/OrgsApi.md#get_all_orgs) | **GET** /orgs | 
*OrgsApi* | [**get_org**](docs/OrgsApi.md#get_org) | **GET** /orgs/{orgId} | 
*ProjectsApi* | [**create_or_update_projects**](docs/ProjectsApi.md#create_or_update_projects) | **POST** /projects | 
*ProjectsApi* | [**delete_project**](docs/ProjectsApi.md#delete_project) | **DELETE** /projects/{projectId} | 
*ProjectsApi* | [**get_all_projects**](docs/ProjectsApi.md#get_all_projects) | **GET** /projects | 
*ProjectsApi* | [**get_project**](docs/ProjectsApi.md#get_project) | **GET** /projects/{projectId} | 
*ProjectsApi* | [**get_project_schema_options**](docs/ProjectsApi.md#get_project_schema_options) | **GET** /schemas | 
*RefsApi* | [**create_refs**](docs/RefsApi.md#create_refs) | **POST** /projects/{projectId}/refs | 
*RefsApi* | [**delete_ref**](docs/RefsApi.md#delete_ref) | **DELETE** /projects/{projectId}/refs/{refId} | 
*RefsApi* | [**get_all_refs**](docs/RefsApi.md#get_all_refs) | **GET** /projects/{projectId}/refs | 
*RefsApi* | [**get_ref**](docs/RefsApi.md#get_ref) | **GET** /projects/{projectId}/refs/{refId} | 
*SearchApi* | [**get_basic_search**](docs/SearchApi.md#get_basic_search) | **GET** /projects/{projectId}/refs/{refId}/search | 
*SearchApi* | [**post_basic_search**](docs/SearchApi.md#post_basic_search) | **POST** /projects/{projectId}/refs/{refId}/search | 
*ViewsApi* | [**create_or_update_views**](docs/ViewsApi.md#create_or_update_views) | **POST** /projects/{projectId}/refs/{refId}/views | 
*ViewsApi* | [**get_documents**](docs/ViewsApi.md#get_documents) | **GET** /projects/{projectId}/refs/{refId}/documents | 
*ViewsApi* | [**get_groups**](docs/ViewsApi.md#get_groups) | **GET** /projects/{projectId}/refs/{refId}/groups | 
*ViewsApi* | [**get_mounts**](docs/ViewsApi.md#get_mounts) | **GET** /projects/{projectId}/refs/{refId}/mounts | 
*ViewsApi* | [**get_view**](docs/ViewsApi.md#get_view) | **GET** /projects/{projectId}/refs/{refId}/views/{viewId} | 
*ViewsApi* | [**get_views**](docs/ViewsApi.md#get_views) | **PUT** /projects/{projectId}/refs/{refId}/views | 
*WebhooksApi* | [**create_or_update_webhooks**](docs/WebhooksApi.md#create_or_update_webhooks) | **POST** /projects/{projectId}/webhooks | 
*WebhooksApi* | [**delete_webhooks**](docs/WebhooksApi.md#delete_webhooks) | **DELETE** /projects/{projectId}/webhooks | 
*WebhooksApi* | [**get_all_webhooks**](docs/WebhooksApi.md#get_all_webhooks) | **GET** /projects/{projectId}/webhooks | 


## Documentation For Models

 - [BasicSearchRequest](docs/BasicSearchRequest.md)
 - [Commit](docs/Commit.md)
 - [CommitsRequest](docs/CommitsRequest.md)
 - [CommitsResponse](docs/CommitsResponse.md)
 - [DocumentsResponse](docs/DocumentsResponse.md)
 - [Element](docs/Element.md)
 - [ElementVersion](docs/ElementVersion.md)
 - [ElementsRequest](docs/ElementsRequest.md)
 - [ElementsResponse](docs/ElementsResponse.md)
 - [ElementsSearchResponse](docs/ElementsSearchResponse.md)
 - [GroupsResponse](docs/GroupsResponse.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [JwtAuthenticationRequest](docs/JwtAuthenticationRequest.md)
 - [JwtAuthenticationResponse](docs/JwtAuthenticationResponse.md)
 - [JwtTokenValidationResponse](docs/JwtTokenValidationResponse.md)
 - [Mount](docs/Mount.md)
 - [MountsResponse](docs/MountsResponse.md)
 - [NotebooksRequest](docs/NotebooksRequest.md)
 - [NotebooksResponse](docs/NotebooksResponse.md)
 - [Org](docs/Org.md)
 - [OrganizationsRequest](docs/OrganizationsRequest.md)
 - [OrganizationsResponse](docs/OrganizationsResponse.md)
 - [Permission](docs/Permission.md)
 - [PermissionLookup](docs/PermissionLookup.md)
 - [PermissionLookupRequest](docs/PermissionLookupRequest.md)
 - [PermissionLookupResponse](docs/PermissionLookupResponse.md)
 - [PermissionResponse](docs/PermissionResponse.md)
 - [PermissionUpdate](docs/PermissionUpdate.md)
 - [PermissionUpdateRequest](docs/PermissionUpdateRequest.md)
 - [PermissionUpdateResponse](docs/PermissionUpdateResponse.md)
 - [PermissionUpdatesResponse](docs/PermissionUpdatesResponse.md)
 - [PermissionsRequest](docs/PermissionsRequest.md)
 - [PermissionsResponse](docs/PermissionsResponse.md)
 - [Project](docs/Project.md)
 - [ProjectsRequest](docs/ProjectsRequest.md)
 - [ProjectsResponse](docs/ProjectsResponse.md)
 - [Ref](docs/Ref.md)
 - [RefsRequest](docs/RefsRequest.md)
 - [RefsResponse](docs/RefsResponse.md)
 - [Rejection](docs/Rejection.md)
 - [Schema](docs/Schema.md)
 - [SchemasResponse](docs/SchemasResponse.md)
 - [User](docs/User.md)
 - [UserCreateRequest](docs/UserCreateRequest.md)
 - [UsersResponse](docs/UsersResponse.md)
 - [Webhook](docs/Webhook.md)
 - [WebhookRequest](docs/WebhookRequest.md)
 - [WebhookResponse](docs/WebhookResponse.md)


## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## bearerToken

- **Type**: Bearer authentication (JWT)


## Author

mms@openmbee.org


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in mms_python_client.apis and mms_python_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from mms_python_client.api.default_api import DefaultApi`
- `from mms_python_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import mms_python_client
from mms_python_client.apis import *
from mms_python_client.models import *
```

