# coding: utf-8

"""
    Selling Partner API for Finances

    The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class TaxWithheldComponent(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'tax_collection_model': 'str',
        'taxes_withheld': 'ChargeComponentList'
    }

    attribute_map = {
        'tax_collection_model': 'TaxCollectionModel',
        'taxes_withheld': 'TaxesWithheld'
    }

    def __init__(self, tax_collection_model=None, taxes_withheld=None):  # noqa: E501
        """TaxWithheldComponent - a model defined in Swagger"""  # noqa: E501
        self._tax_collection_model = None
        self._taxes_withheld = None
        self.discriminator = None
        if tax_collection_model is not None:
            self.tax_collection_model = tax_collection_model
        if taxes_withheld is not None:
            self.taxes_withheld = taxes_withheld

    @property
    def tax_collection_model(self):
        """Gets the tax_collection_model of this TaxWithheldComponent.  # noqa: E501

        The tax collection model applied to the item.  Possible values:  * MarketplaceFacilitator - Tax is withheld and remitted to the taxing authority by Amazon on behalf of the seller.  * Standard - Tax is paid to the seller and not remitted to the taxing authority by Amazon.  # noqa: E501

        :return: The tax_collection_model of this TaxWithheldComponent.  # noqa: E501
        :rtype: str
        """
        return self._tax_collection_model

    @tax_collection_model.setter
    def tax_collection_model(self, tax_collection_model):
        """Sets the tax_collection_model of this TaxWithheldComponent.

        The tax collection model applied to the item.  Possible values:  * MarketplaceFacilitator - Tax is withheld and remitted to the taxing authority by Amazon on behalf of the seller.  * Standard - Tax is paid to the seller and not remitted to the taxing authority by Amazon.  # noqa: E501

        :param tax_collection_model: The tax_collection_model of this TaxWithheldComponent.  # noqa: E501
        :type: str
        """

        self._tax_collection_model = tax_collection_model

    @property
    def taxes_withheld(self):
        """Gets the taxes_withheld of this TaxWithheldComponent.  # noqa: E501


        :return: The taxes_withheld of this TaxWithheldComponent.  # noqa: E501
        :rtype: ChargeComponentList
        """
        return self._taxes_withheld

    @taxes_withheld.setter
    def taxes_withheld(self, taxes_withheld):
        """Sets the taxes_withheld of this TaxWithheldComponent.


        :param taxes_withheld: The taxes_withheld of this TaxWithheldComponent.  # noqa: E501
        :type: ChargeComponentList
        """

        self._taxes_withheld = taxes_withheld

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TaxWithheldComponent, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TaxWithheldComponent):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
