import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface TeamConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team.html#create_default_maintainer Team#create_default_maintainer}.
     *
     * @stability stable
     */
    readonly createDefaultMaintainer?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team.html#description Team#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team.html#ldap_dn Team#ldap_dn}.
     *
     * @stability stable
     */
    readonly ldapDn?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team.html#name Team#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team.html#parent_team_id Team#parent_team_id}.
     *
     * @stability stable
     */
    readonly parentTeamId?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team.html#privacy Team#privacy}.
     *
     * @stability stable
     */
    readonly privacy?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/r/team.html github_team}.
 *
 * @stability stable
 */
export declare class Team extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/r/team.html github_team} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: TeamConfig);
    private _createDefaultMaintainer?;
    /**
     * @stability stable
     */
    get createDefaultMaintainer(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set createDefaultMaintainer(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCreateDefaultMaintainer(): void;
    /**
     * @stability stable
     */
    get createDefaultMaintainerInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _ldapDn?;
    /**
     * @stability stable
     */
    get ldapDn(): string;
    /**
     * @stability stable
     */
    set ldapDn(value: string);
    /**
     * @stability stable
     */
    resetLdapDn(): void;
    /**
     * @stability stable
     */
    get ldapDnInput(): string | undefined;
    /**
     * @stability stable
     */
    get membersCount(): number;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    /**
     * @stability stable
     */
    get nodeId(): string;
    private _parentTeamId?;
    /**
     * @stability stable
     */
    get parentTeamId(): number;
    /**
     * @stability stable
     */
    set parentTeamId(value: number);
    /**
     * @stability stable
     */
    resetParentTeamId(): void;
    /**
     * @stability stable
     */
    get parentTeamIdInput(): number | undefined;
    private _privacy?;
    /**
     * @stability stable
     */
    get privacy(): string;
    /**
     * @stability stable
     */
    set privacy(value: string);
    /**
     * @stability stable
     */
    resetPrivacy(): void;
    /**
     * @stability stable
     */
    get privacyInput(): string | undefined;
    /**
     * @stability stable
     */
    get slug(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
