import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface TeamSyncGroupMappingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_sync_group_mapping.html#team_slug TeamSyncGroupMapping#team_slug}.
     *
     * @stability stable
     */
    readonly teamSlug: string;
    /**
     * group block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_sync_group_mapping.html#group TeamSyncGroupMapping#group}
     *
     * @stability stable
     */
    readonly group?: TeamSyncGroupMappingGroup[];
}
/**
 * @stability stable
 */
export interface TeamSyncGroupMappingGroup {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_sync_group_mapping.html#group_description TeamSyncGroupMapping#group_description}.
     *
     * @stability stable
     */
    readonly groupDescription: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_sync_group_mapping.html#group_id TeamSyncGroupMapping#group_id}.
     *
     * @stability stable
     */
    readonly groupId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_sync_group_mapping.html#group_name TeamSyncGroupMapping#group_name}.
     *
     * @stability stable
     */
    readonly groupName: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/r/team_sync_group_mapping.html github_team_sync_group_mapping}.
 *
 * @stability stable
 */
export declare class TeamSyncGroupMapping extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/r/team_sync_group_mapping.html github_team_sync_group_mapping} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: TeamSyncGroupMappingConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _teamSlug;
    /**
     * @stability stable
     */
    get teamSlug(): string;
    /**
     * @stability stable
     */
    set teamSlug(value: string);
    /**
     * @stability stable
     */
    get teamSlugInput(): string;
    private _group?;
    /**
     * @stability stable
     */
    get group(): TeamSyncGroupMappingGroup[];
    /**
     * @stability stable
     */
    set group(value: TeamSyncGroupMappingGroup[]);
    /**
     * @stability stable
     */
    resetGroup(): void;
    /**
     * @stability stable
     */
    get groupInput(): TeamSyncGroupMappingGroup[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
