import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface TeamRepositoryConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_repository.html#permission TeamRepository#permission}.
     *
     * @stability stable
     */
    readonly permission?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_repository.html#repository TeamRepository#repository}.
     *
     * @stability stable
     */
    readonly repository: string;
    /**
     * ID or slug of team.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_repository.html#team_id TeamRepository#team_id}
     *
     * @stability stable
     */
    readonly teamId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/r/team_repository.html github_team_repository}.
 *
 * @stability stable
 */
export declare class TeamRepository extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/r/team_repository.html github_team_repository} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: TeamRepositoryConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _permission?;
    /**
     * @stability stable
     */
    get permission(): string;
    /**
     * @stability stable
     */
    set permission(value: string);
    /**
     * @stability stable
     */
    resetPermission(): void;
    /**
     * @stability stable
     */
    get permissionInput(): string | undefined;
    private _repository;
    /**
     * @stability stable
     */
    get repository(): string;
    /**
     * @stability stable
     */
    set repository(value: string);
    /**
     * @stability stable
     */
    get repositoryInput(): string;
    private _teamId;
    /**
     * @stability stable
     */
    get teamId(): string;
    /**
     * @stability stable
     */
    set teamId(value: string);
    /**
     * @stability stable
     */
    get teamIdInput(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
