import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface TeamMembershipConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_membership.html#role TeamMembership#role}.
     *
     * @stability stable
     */
    readonly role?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_membership.html#team_id TeamMembership#team_id}.
     *
     * @stability stable
     */
    readonly teamId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/team_membership.html#username TeamMembership#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/r/team_membership.html github_team_membership}.
 *
 * @stability stable
 */
export declare class TeamMembership extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/r/team_membership.html github_team_membership} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: TeamMembershipConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _role?;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    resetRole(): void;
    /**
     * @stability stable
     */
    get roleInput(): string | undefined;
    private _teamId;
    /**
     * @stability stable
     */
    get teamId(): string;
    /**
     * @stability stable
     */
    set teamId(value: string);
    /**
     * @stability stable
     */
    get teamIdInput(): string;
    private _username;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
