import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RepositoryConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#allow_merge_commit Repository#allow_merge_commit}.
     *
     * @stability stable
     */
    readonly allowMergeCommit?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#allow_rebase_merge Repository#allow_rebase_merge}.
     *
     * @stability stable
     */
    readonly allowRebaseMerge?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#allow_squash_merge Repository#allow_squash_merge}.
     *
     * @stability stable
     */
    readonly allowSquashMerge?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#archive_on_destroy Repository#archive_on_destroy}.
     *
     * @stability stable
     */
    readonly archiveOnDestroy?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#archived Repository#archived}.
     *
     * @stability stable
     */
    readonly archived?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#auto_init Repository#auto_init}.
     *
     * @stability stable
     */
    readonly autoInit?: boolean | cdktf.IResolvable;
    /**
     * Can only be set after initial repository creation, and only if the target branch exists.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#default_branch Repository#default_branch}
     *
     * @stability stable
     */
    readonly defaultBranch?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#delete_branch_on_merge Repository#delete_branch_on_merge}.
     *
     * @stability stable
     */
    readonly deleteBranchOnMerge?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#description Repository#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#gitignore_template Repository#gitignore_template}.
     *
     * @stability stable
     */
    readonly gitignoreTemplate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#has_downloads Repository#has_downloads}.
     *
     * @stability stable
     */
    readonly hasDownloads?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#has_issues Repository#has_issues}.
     *
     * @stability stable
     */
    readonly hasIssues?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#has_projects Repository#has_projects}.
     *
     * @stability stable
     */
    readonly hasProjects?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#has_wiki Repository#has_wiki}.
     *
     * @stability stable
     */
    readonly hasWiki?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#homepage_url Repository#homepage_url}.
     *
     * @stability stable
     */
    readonly homepageUrl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#is_template Repository#is_template}.
     *
     * @stability stable
     */
    readonly isTemplate?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#license_template Repository#license_template}.
     *
     * @stability stable
     */
    readonly licenseTemplate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#name Repository#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#private Repository#private}.
     *
     * @stability stable
     */
    readonly private?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#topics Repository#topics}.
     *
     * @stability stable
     */
    readonly topics?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#visibility Repository#visibility}.
     *
     * @stability stable
     */
    readonly visibility?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#vulnerability_alerts Repository#vulnerability_alerts}.
     *
     * @stability stable
     */
    readonly vulnerabilityAlerts?: boolean | cdktf.IResolvable;
    /**
     * pages block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#pages Repository#pages}
     *
     * @stability stable
     */
    readonly pages?: RepositoryPages[];
    /**
     * template block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#template Repository#template}
     *
     * @stability stable
     */
    readonly template?: RepositoryTemplate[];
}
/**
 * @stability stable
 */
export interface RepositoryPagesSource {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#branch Repository#branch}.
     *
     * @stability stable
     */
    readonly branch: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#path Repository#path}.
     *
     * @stability stable
     */
    readonly path?: string;
}
/**
 * @stability stable
 */
export interface RepositoryPages {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#cname Repository#cname}.
     *
     * @stability stable
     */
    readonly cname?: string;
    /**
     * source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#source Repository#source}
     *
     * @stability stable
     */
    readonly source: RepositoryPagesSource[];
}
/**
 * @stability stable
 */
export interface RepositoryTemplate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#owner Repository#owner}.
     *
     * @stability stable
     */
    readonly owner: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository.html#repository Repository#repository}.
     *
     * @stability stable
     */
    readonly repository: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/r/repository.html github_repository}.
 *
 * @stability stable
 */
export declare class Repository extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/r/repository.html github_repository} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RepositoryConfig);
    private _allowMergeCommit?;
    /**
     * @stability stable
     */
    get allowMergeCommit(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowMergeCommit(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowMergeCommit(): void;
    /**
     * @stability stable
     */
    get allowMergeCommitInput(): boolean | cdktf.IResolvable | undefined;
    private _allowRebaseMerge?;
    /**
     * @stability stable
     */
    get allowRebaseMerge(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowRebaseMerge(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowRebaseMerge(): void;
    /**
     * @stability stable
     */
    get allowRebaseMergeInput(): boolean | cdktf.IResolvable | undefined;
    private _allowSquashMerge?;
    /**
     * @stability stable
     */
    get allowSquashMerge(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowSquashMerge(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowSquashMerge(): void;
    /**
     * @stability stable
     */
    get allowSquashMergeInput(): boolean | cdktf.IResolvable | undefined;
    private _archiveOnDestroy?;
    /**
     * @stability stable
     */
    get archiveOnDestroy(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set archiveOnDestroy(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetArchiveOnDestroy(): void;
    /**
     * @stability stable
     */
    get archiveOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _archived?;
    /**
     * @stability stable
     */
    get archived(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set archived(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetArchived(): void;
    /**
     * @stability stable
     */
    get archivedInput(): boolean | cdktf.IResolvable | undefined;
    private _autoInit?;
    /**
     * @stability stable
     */
    get autoInit(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoInit(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoInit(): void;
    /**
     * @stability stable
     */
    get autoInitInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultBranch?;
    /**
     * @stability stable
     */
    get defaultBranch(): string;
    /**
     * @stability stable
     */
    set defaultBranch(value: string);
    /**
     * @stability stable
     */
    resetDefaultBranch(): void;
    /**
     * @stability stable
     */
    get defaultBranchInput(): string | undefined;
    private _deleteBranchOnMerge?;
    /**
     * @stability stable
     */
    get deleteBranchOnMerge(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set deleteBranchOnMerge(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDeleteBranchOnMerge(): void;
    /**
     * @stability stable
     */
    get deleteBranchOnMergeInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get fullName(): string;
    /**
     * @stability stable
     */
    get gitCloneUrl(): string;
    private _gitignoreTemplate?;
    /**
     * @stability stable
     */
    get gitignoreTemplate(): string;
    /**
     * @stability stable
     */
    set gitignoreTemplate(value: string);
    /**
     * @stability stable
     */
    resetGitignoreTemplate(): void;
    /**
     * @stability stable
     */
    get gitignoreTemplateInput(): string | undefined;
    private _hasDownloads?;
    /**
     * @stability stable
     */
    get hasDownloads(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hasDownloads(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHasDownloads(): void;
    /**
     * @stability stable
     */
    get hasDownloadsInput(): boolean | cdktf.IResolvable | undefined;
    private _hasIssues?;
    /**
     * @stability stable
     */
    get hasIssues(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hasIssues(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHasIssues(): void;
    /**
     * @stability stable
     */
    get hasIssuesInput(): boolean | cdktf.IResolvable | undefined;
    private _hasProjects?;
    /**
     * @stability stable
     */
    get hasProjects(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hasProjects(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHasProjects(): void;
    /**
     * @stability stable
     */
    get hasProjectsInput(): boolean | cdktf.IResolvable | undefined;
    private _hasWiki?;
    /**
     * @stability stable
     */
    get hasWiki(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hasWiki(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHasWiki(): void;
    /**
     * @stability stable
     */
    get hasWikiInput(): boolean | cdktf.IResolvable | undefined;
    private _homepageUrl?;
    /**
     * @stability stable
     */
    get homepageUrl(): string;
    /**
     * @stability stable
     */
    set homepageUrl(value: string);
    /**
     * @stability stable
     */
    resetHomepageUrl(): void;
    /**
     * @stability stable
     */
    get homepageUrlInput(): string | undefined;
    /**
     * @stability stable
     */
    get htmlUrl(): string;
    /**
     * @stability stable
     */
    get httpCloneUrl(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _isTemplate?;
    /**
     * @stability stable
     */
    get isTemplate(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isTemplate(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsTemplate(): void;
    /**
     * @stability stable
     */
    get isTemplateInput(): boolean | cdktf.IResolvable | undefined;
    private _licenseTemplate?;
    /**
     * @stability stable
     */
    get licenseTemplate(): string;
    /**
     * @stability stable
     */
    set licenseTemplate(value: string);
    /**
     * @stability stable
     */
    resetLicenseTemplate(): void;
    /**
     * @stability stable
     */
    get licenseTemplateInput(): string | undefined;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    /**
     * @stability stable
     */
    get nodeId(): string;
    private _private?;
    /**
     * @stability stable
     */
    get private(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set private(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPrivate(): void;
    /**
     * @stability stable
     */
    get privateInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get repoId(): number;
    /**
     * @stability stable
     */
    get sshCloneUrl(): string;
    /**
     * @stability stable
     */
    get svnUrl(): string;
    private _topics?;
    /**
     * @stability stable
     */
    get topics(): string[];
    /**
     * @stability stable
     */
    set topics(value: string[]);
    /**
     * @stability stable
     */
    resetTopics(): void;
    /**
     * @stability stable
     */
    get topicsInput(): string[] | undefined;
    private _visibility?;
    /**
     * @stability stable
     */
    get visibility(): string;
    /**
     * @stability stable
     */
    set visibility(value: string);
    /**
     * @stability stable
     */
    resetVisibility(): void;
    /**
     * @stability stable
     */
    get visibilityInput(): string | undefined;
    private _vulnerabilityAlerts?;
    /**
     * @stability stable
     */
    get vulnerabilityAlerts(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set vulnerabilityAlerts(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetVulnerabilityAlerts(): void;
    /**
     * @stability stable
     */
    get vulnerabilityAlertsInput(): boolean | cdktf.IResolvable | undefined;
    private _pages?;
    /**
     * @stability stable
     */
    get pages(): RepositoryPages[];
    /**
     * @stability stable
     */
    set pages(value: RepositoryPages[]);
    /**
     * @stability stable
     */
    resetPages(): void;
    /**
     * @stability stable
     */
    get pagesInput(): RepositoryPages[] | undefined;
    private _template?;
    /**
     * @stability stable
     */
    get template(): RepositoryTemplate[];
    /**
     * @stability stable
     */
    set template(value: RepositoryTemplate[]);
    /**
     * @stability stable
     */
    resetTemplate(): void;
    /**
     * @stability stable
     */
    get templateInput(): RepositoryTemplate[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
