import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RepositoryWebhookConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html#active RepositoryWebhook#active}.
     *
     * @stability stable
     */
    readonly active?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html#events RepositoryWebhook#events}.
     *
     * @stability stable
     */
    readonly events: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html#name RepositoryWebhook#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html#repository RepositoryWebhook#repository}.
     *
     * @stability stable
     */
    readonly repository: string;
    /**
     * configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html#configuration RepositoryWebhook#configuration}
     *
     * @stability stable
     */
    readonly configuration?: RepositoryWebhookConfiguration[];
}
/**
 * @stability stable
 */
export interface RepositoryWebhookConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html#content_type RepositoryWebhook#content_type}.
     *
     * @stability stable
     */
    readonly contentType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html#insecure_ssl RepositoryWebhook#insecure_ssl}.
     *
     * @stability stable
     */
    readonly insecureSsl?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html#secret RepositoryWebhook#secret}.
     *
     * @stability stable
     */
    readonly secret?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html#url RepositoryWebhook#url}.
     *
     * @stability stable
     */
    readonly url: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html github_repository_webhook}.
 *
 * @stability stable
 */
export declare class RepositoryWebhook extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/r/repository_webhook.html github_repository_webhook} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RepositoryWebhookConfig);
    private _active?;
    /**
     * @stability stable
     */
    get active(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set active(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetActive(): void;
    /**
     * @stability stable
     */
    get activeInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get etag(): string;
    private _events;
    /**
     * @stability stable
     */
    get events(): string[];
    /**
     * @stability stable
     */
    set events(value: string[]);
    /**
     * @stability stable
     */
    get eventsInput(): string[];
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _repository;
    /**
     * @stability stable
     */
    get repository(): string;
    /**
     * @stability stable
     */
    set repository(value: string);
    /**
     * @stability stable
     */
    get repositoryInput(): string;
    /**
     * @stability stable
     */
    get url(): string;
    private _configuration?;
    /**
     * @stability stable
     */
    get configuration(): RepositoryWebhookConfiguration[];
    /**
     * @stability stable
     */
    set configuration(value: RepositoryWebhookConfiguration[]);
    /**
     * @stability stable
     */
    resetConfiguration(): void;
    /**
     * @stability stable
     */
    get configurationInput(): RepositoryWebhookConfiguration[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
