import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RepositoryPullRequestConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html#base_ref RepositoryPullRequest#base_ref}.
     *
     * @stability stable
     */
    readonly baseRef: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html#base_repository RepositoryPullRequest#base_repository}.
     *
     * @stability stable
     */
    readonly baseRepository: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html#body RepositoryPullRequest#body}.
     *
     * @stability stable
     */
    readonly body?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html#head_ref RepositoryPullRequest#head_ref}.
     *
     * @stability stable
     */
    readonly headRef: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html#maintainer_can_modify RepositoryPullRequest#maintainer_can_modify}.
     *
     * @stability stable
     */
    readonly maintainerCanModify?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html#owner RepositoryPullRequest#owner}.
     *
     * @stability stable
     */
    readonly owner?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html#title RepositoryPullRequest#title}.
     *
     * @stability stable
     */
    readonly title: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html github_repository_pull_request}.
 *
 * @stability stable
 */
export declare class RepositoryPullRequest extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/r/repository_pull_request.html github_repository_pull_request} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RepositoryPullRequestConfig);
    private _baseRef;
    /**
     * @stability stable
     */
    get baseRef(): string;
    /**
     * @stability stable
     */
    set baseRef(value: string);
    /**
     * @stability stable
     */
    get baseRefInput(): string;
    private _baseRepository;
    /**
     * @stability stable
     */
    get baseRepository(): string;
    /**
     * @stability stable
     */
    set baseRepository(value: string);
    /**
     * @stability stable
     */
    get baseRepositoryInput(): string;
    /**
     * @stability stable
     */
    get baseSha(): string;
    private _body?;
    /**
     * @stability stable
     */
    get body(): string;
    /**
     * @stability stable
     */
    set body(value: string);
    /**
     * @stability stable
     */
    resetBody(): void;
    /**
     * @stability stable
     */
    get bodyInput(): string | undefined;
    /**
     * @stability stable
     */
    get draft(): cdktf.IResolvable;
    private _headRef;
    /**
     * @stability stable
     */
    get headRef(): string;
    /**
     * @stability stable
     */
    set headRef(value: string);
    /**
     * @stability stable
     */
    get headRefInput(): string;
    /**
     * @stability stable
     */
    get headSha(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get labels(): string[];
    private _maintainerCanModify?;
    /**
     * @stability stable
     */
    get maintainerCanModify(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set maintainerCanModify(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMaintainerCanModify(): void;
    /**
     * @stability stable
     */
    get maintainerCanModifyInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get number(): number;
    /**
     * @stability stable
     */
    get openedAt(): number;
    /**
     * @stability stable
     */
    get openedBy(): string;
    private _owner?;
    /**
     * @stability stable
     */
    get owner(): string;
    /**
     * @stability stable
     */
    set owner(value: string);
    /**
     * @stability stable
     */
    resetOwner(): void;
    /**
     * @stability stable
     */
    get ownerInput(): string | undefined;
    /**
     * @stability stable
     */
    get state(): string;
    private _title;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    get titleInput(): string;
    /**
     * @stability stable
     */
    get updatedAt(): number;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
