import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RepositoryProjectConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_project.html#body RepositoryProject#body}.
     *
     * @stability stable
     */
    readonly body?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_project.html#name RepositoryProject#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_project.html#repository RepositoryProject#repository}.
     *
     * @stability stable
     */
    readonly repository: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/r/repository_project.html github_repository_project}.
 *
 * @stability stable
 */
export declare class RepositoryProject extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/r/repository_project.html github_repository_project} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RepositoryProjectConfig);
    private _body?;
    /**
     * @stability stable
     */
    get body(): string;
    /**
     * @stability stable
     */
    set body(value: string);
    /**
     * @stability stable
     */
    resetBody(): void;
    /**
     * @stability stable
     */
    get bodyInput(): string | undefined;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _repository;
    /**
     * @stability stable
     */
    get repository(): string;
    /**
     * @stability stable
     */
    set repository(value: string);
    /**
     * @stability stable
     */
    get repositoryInput(): string;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
