import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RepositoryMilestoneConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_milestone.html#description RepositoryMilestone#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * in yyyy-mm-dd format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_milestone.html#due_date RepositoryMilestone#due_date}
     *
     * @stability stable
     */
    readonly dueDate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_milestone.html#owner RepositoryMilestone#owner}.
     *
     * @stability stable
     */
    readonly owner: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_milestone.html#repository RepositoryMilestone#repository}.
     *
     * @stability stable
     */
    readonly repository: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_milestone.html#state RepositoryMilestone#state}.
     *
     * @stability stable
     */
    readonly state?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_milestone.html#title RepositoryMilestone#title}.
     *
     * @stability stable
     */
    readonly title: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/r/repository_milestone.html github_repository_milestone}.
 *
 * @stability stable
 */
export declare class RepositoryMilestone extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/r/repository_milestone.html github_repository_milestone} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RepositoryMilestoneConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _dueDate?;
    /**
     * @stability stable
     */
    get dueDate(): string;
    /**
     * @stability stable
     */
    set dueDate(value: string);
    /**
     * @stability stable
     */
    resetDueDate(): void;
    /**
     * @stability stable
     */
    get dueDateInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get number(): number;
    private _owner;
    /**
     * @stability stable
     */
    get owner(): string;
    /**
     * @stability stable
     */
    set owner(value: string);
    /**
     * @stability stable
     */
    get ownerInput(): string;
    private _repository;
    /**
     * @stability stable
     */
    get repository(): string;
    /**
     * @stability stable
     */
    set repository(value: string);
    /**
     * @stability stable
     */
    get repositoryInput(): string;
    private _state?;
    /**
     * @stability stable
     */
    get state(): string;
    /**
     * @stability stable
     */
    set state(value: string);
    /**
     * @stability stable
     */
    resetState(): void;
    /**
     * @stability stable
     */
    get stateInput(): string | undefined;
    private _title;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    get titleInput(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
