import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RepositoryFileConfig extends cdktf.TerraformMetaArguments {
    /**
     * The branch name, defaults to "main".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_file.html#branch RepositoryFile#branch}
     *
     * @stability stable
     */
    readonly branch?: string;
    /**
     * The commit author name, defaults to the authenticated user's name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_file.html#commit_author RepositoryFile#commit_author}
     *
     * @stability stable
     */
    readonly commitAuthor?: string;
    /**
     * The commit author email address, defaults to the authenticated user's email address.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_file.html#commit_email RepositoryFile#commit_email}
     *
     * @stability stable
     */
    readonly commitEmail?: string;
    /**
     * The commit message when creating or updating the file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_file.html#commit_message RepositoryFile#commit_message}
     *
     * @stability stable
     */
    readonly commitMessage?: string;
    /**
     * The file's content.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_file.html#content RepositoryFile#content}
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * The file path to manage.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_file.html#file RepositoryFile#file}
     *
     * @stability stable
     */
    readonly file: string;
    /**
     * Enable overwriting existing files, defaults to "false".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_file.html#overwrite_on_create RepositoryFile#overwrite_on_create}
     *
     * @stability stable
     */
    readonly overwriteOnCreate?: boolean | cdktf.IResolvable;
    /**
     * The repository name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_file.html#repository RepositoryFile#repository}
     *
     * @stability stable
     */
    readonly repository: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/r/repository_file.html github_repository_file}.
 *
 * @stability stable
 */
export declare class RepositoryFile extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/r/repository_file.html github_repository_file} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RepositoryFileConfig);
    private _branch?;
    /**
     * @stability stable
     */
    get branch(): string;
    /**
     * @stability stable
     */
    set branch(value: string);
    /**
     * @stability stable
     */
    resetBranch(): void;
    /**
     * @stability stable
     */
    get branchInput(): string | undefined;
    private _commitAuthor?;
    /**
     * @stability stable
     */
    get commitAuthor(): string;
    /**
     * @stability stable
     */
    set commitAuthor(value: string);
    /**
     * @stability stable
     */
    resetCommitAuthor(): void;
    /**
     * @stability stable
     */
    get commitAuthorInput(): string | undefined;
    private _commitEmail?;
    /**
     * @stability stable
     */
    get commitEmail(): string;
    /**
     * @stability stable
     */
    set commitEmail(value: string);
    /**
     * @stability stable
     */
    resetCommitEmail(): void;
    /**
     * @stability stable
     */
    get commitEmailInput(): string | undefined;
    private _commitMessage?;
    /**
     * @stability stable
     */
    get commitMessage(): string;
    /**
     * @stability stable
     */
    set commitMessage(value: string);
    /**
     * @stability stable
     */
    resetCommitMessage(): void;
    /**
     * @stability stable
     */
    get commitMessageInput(): string | undefined;
    /**
     * @stability stable
     */
    get commitSha(): string;
    private _content;
    /**
     * @stability stable
     */
    get content(): string;
    /**
     * @stability stable
     */
    set content(value: string);
    /**
     * @stability stable
     */
    get contentInput(): string;
    private _file;
    /**
     * @stability stable
     */
    get file(): string;
    /**
     * @stability stable
     */
    set file(value: string);
    /**
     * @stability stable
     */
    get fileInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _overwriteOnCreate?;
    /**
     * @stability stable
     */
    get overwriteOnCreate(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set overwriteOnCreate(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOverwriteOnCreate(): void;
    /**
     * @stability stable
     */
    get overwriteOnCreateInput(): boolean | cdktf.IResolvable | undefined;
    private _repository;
    /**
     * @stability stable
     */
    get repository(): string;
    /**
     * @stability stable
     */
    set repository(value: string);
    /**
     * @stability stable
     */
    get repositoryInput(): string;
    /**
     * @stability stable
     */
    get sha(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
