import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RepositoryEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_environment.html#environment RepositoryEnvironment#environment}.
     *
     * @stability stable
     */
    readonly environment: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_environment.html#repository RepositoryEnvironment#repository}.
     *
     * @stability stable
     */
    readonly repository: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_environment.html#wait_timer RepositoryEnvironment#wait_timer}.
     *
     * @stability stable
     */
    readonly waitTimer?: number;
    /**
     * deployment_branch_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_environment.html#deployment_branch_policy RepositoryEnvironment#deployment_branch_policy}
     *
     * @stability stable
     */
    readonly deploymentBranchPolicy?: RepositoryEnvironmentDeploymentBranchPolicy[];
    /**
     * reviewers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_environment.html#reviewers RepositoryEnvironment#reviewers}
     *
     * @stability stable
     */
    readonly reviewers?: RepositoryEnvironmentReviewers[];
}
/**
 * @stability stable
 */
export interface RepositoryEnvironmentDeploymentBranchPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_environment.html#custom_branch_policies RepositoryEnvironment#custom_branch_policies}.
     *
     * @stability stable
     */
    readonly customBranchPolicies: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_environment.html#protected_branches RepositoryEnvironment#protected_branches}.
     *
     * @stability stable
     */
    readonly protectedBranches: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface RepositoryEnvironmentReviewers {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_environment.html#teams RepositoryEnvironment#teams}.
     *
     * @stability stable
     */
    readonly teams?: number[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_environment.html#users RepositoryEnvironment#users}.
     *
     * @stability stable
     */
    readonly users?: number[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/r/repository_environment.html github_repository_environment}.
 *
 * @stability stable
 */
export declare class RepositoryEnvironment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/r/repository_environment.html github_repository_environment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RepositoryEnvironmentConfig);
    private _environment;
    /**
     * @stability stable
     */
    get environment(): string;
    /**
     * @stability stable
     */
    set environment(value: string);
    /**
     * @stability stable
     */
    get environmentInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _repository;
    /**
     * @stability stable
     */
    get repository(): string;
    /**
     * @stability stable
     */
    set repository(value: string);
    /**
     * @stability stable
     */
    get repositoryInput(): string;
    private _waitTimer?;
    /**
     * @stability stable
     */
    get waitTimer(): number;
    /**
     * @stability stable
     */
    set waitTimer(value: number);
    /**
     * @stability stable
     */
    resetWaitTimer(): void;
    /**
     * @stability stable
     */
    get waitTimerInput(): number | undefined;
    private _deploymentBranchPolicy?;
    /**
     * @stability stable
     */
    get deploymentBranchPolicy(): RepositoryEnvironmentDeploymentBranchPolicy[];
    /**
     * @stability stable
     */
    set deploymentBranchPolicy(value: RepositoryEnvironmentDeploymentBranchPolicy[]);
    /**
     * @stability stable
     */
    resetDeploymentBranchPolicy(): void;
    /**
     * @stability stable
     */
    get deploymentBranchPolicyInput(): RepositoryEnvironmentDeploymentBranchPolicy[] | undefined;
    private _reviewers?;
    /**
     * @stability stable
     */
    get reviewers(): RepositoryEnvironmentReviewers[];
    /**
     * @stability stable
     */
    set reviewers(value: RepositoryEnvironmentReviewers[]);
    /**
     * @stability stable
     */
    resetReviewers(): void;
    /**
     * @stability stable
     */
    get reviewersInput(): RepositoryEnvironmentReviewers[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
