import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RepositoryDeployKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_deploy_key.html#key RepositoryDeployKey#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_deploy_key.html#read_only RepositoryDeployKey#read_only}.
     *
     * @stability stable
     */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_deploy_key.html#repository RepositoryDeployKey#repository}.
     *
     * @stability stable
     */
    readonly repository: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_deploy_key.html#title RepositoryDeployKey#title}.
     *
     * @stability stable
     */
    readonly title: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/r/repository_deploy_key.html github_repository_deploy_key}.
 *
 * @stability stable
 */
export declare class RepositoryDeployKey extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/r/repository_deploy_key.html github_repository_deploy_key} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RepositoryDeployKeyConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _key;
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    set key(value: string);
    /**
     * @stability stable
     */
    get keyInput(): string;
    private _readOnly?;
    /**
     * @stability stable
     */
    get readOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set readOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReadOnly(): void;
    /**
     * @stability stable
     */
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _repository;
    /**
     * @stability stable
     */
    get repository(): string;
    /**
     * @stability stable
     */
    set repository(value: string);
    /**
     * @stability stable
     */
    get repositoryInput(): string;
    private _title;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    get titleInput(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
