import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RepositoryCollaboratorConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_collaborator.html#permission RepositoryCollaborator#permission}.
     *
     * @stability stable
     */
    readonly permission?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_collaborator.html#permission_diff_suppression RepositoryCollaborator#permission_diff_suppression}.
     *
     * @stability stable
     */
    readonly permissionDiffSuppression?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_collaborator.html#repository RepositoryCollaborator#repository}.
     *
     * @stability stable
     */
    readonly repository: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/repository_collaborator.html#username RepositoryCollaborator#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/r/repository_collaborator.html github_repository_collaborator}.
 *
 * @stability stable
 */
export declare class RepositoryCollaborator extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/r/repository_collaborator.html github_repository_collaborator} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RepositoryCollaboratorConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get invitationId(): string;
    private _permission?;
    /**
     * @stability stable
     */
    get permission(): string;
    /**
     * @stability stable
     */
    set permission(value: string);
    /**
     * @stability stable
     */
    resetPermission(): void;
    /**
     * @stability stable
     */
    get permissionInput(): string | undefined;
    private _permissionDiffSuppression?;
    /**
     * @stability stable
     */
    get permissionDiffSuppression(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set permissionDiffSuppression(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPermissionDiffSuppression(): void;
    /**
     * @stability stable
     */
    get permissionDiffSuppressionInput(): boolean | cdktf.IResolvable | undefined;
    private _repository;
    /**
     * @stability stable
     */
    get repository(): string;
    /**
     * @stability stable
     */
    set repository(value: string);
    /**
     * @stability stable
     */
    get repositoryInput(): string;
    private _username;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
