import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ProjectCardConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/project_card.html#column_id ProjectCard#column_id}.
     *
     * @stability stable
     */
    readonly columnId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/project_card.html#note ProjectCard#note}.
     *
     * @stability stable
     */
    readonly note: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/r/project_card.html github_project_card}.
 *
 * @stability stable
 */
export declare class ProjectCard extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/r/project_card.html github_project_card} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ProjectCardConfig);
    /**
     * @stability stable
     */
    get cardId(): number;
    private _columnId;
    /**
     * @stability stable
     */
    get columnId(): string;
    /**
     * @stability stable
     */
    set columnId(value: string);
    /**
     * @stability stable
     */
    get columnIdInput(): string;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _note;
    /**
     * @stability stable
     */
    get note(): string;
    /**
     * @stability stable
     */
    set note(value: string);
    /**
     * @stability stable
     */
    get noteInput(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
