import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface OrganizationWebhookConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/organization_webhook.html#active OrganizationWebhook#active}.
     *
     * @stability stable
     */
    readonly active?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/organization_webhook.html#events OrganizationWebhook#events}.
     *
     * @stability stable
     */
    readonly events: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/organization_webhook.html#name OrganizationWebhook#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/organization_webhook.html#configuration OrganizationWebhook#configuration}
     *
     * @stability stable
     */
    readonly configuration?: OrganizationWebhookConfiguration[];
}
/**
 * @stability stable
 */
export interface OrganizationWebhookConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/organization_webhook.html#content_type OrganizationWebhook#content_type}.
     *
     * @stability stable
     */
    readonly contentType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/organization_webhook.html#insecure_ssl OrganizationWebhook#insecure_ssl}.
     *
     * @stability stable
     */
    readonly insecureSsl?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/organization_webhook.html#secret OrganizationWebhook#secret}.
     *
     * @stability stable
     */
    readonly secret?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/organization_webhook.html#url OrganizationWebhook#url}.
     *
     * @stability stable
     */
    readonly url: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/r/organization_webhook.html github_organization_webhook}.
 *
 * @stability stable
 */
export declare class OrganizationWebhook extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/r/organization_webhook.html github_organization_webhook} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: OrganizationWebhookConfig);
    private _active?;
    /**
     * @stability stable
     */
    get active(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set active(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetActive(): void;
    /**
     * @stability stable
     */
    get activeInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get etag(): string;
    private _events;
    /**
     * @stability stable
     */
    get events(): string[];
    /**
     * @stability stable
     */
    set events(value: string[]);
    /**
     * @stability stable
     */
    get eventsInput(): string[];
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get url(): string;
    private _configuration?;
    /**
     * @stability stable
     */
    get configuration(): OrganizationWebhookConfiguration[];
    /**
     * @stability stable
     */
    set configuration(value: OrganizationWebhookConfiguration[]);
    /**
     * @stability stable
     */
    resetConfiguration(): void;
    /**
     * @stability stable
     */
    get configurationInput(): OrganizationWebhookConfiguration[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
