import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface GithubProviderConfig {
    /**
     * The GitHub Base API URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github#base_url GithubProvider#base_url}
     *
     * @stability stable
     */
    readonly baseUrl?: string;
    /**
     * Enable `insecure` mode for testing purposes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github#insecure GithubProvider#insecure}
     *
     * @stability stable
     */
    readonly insecure?: boolean | cdktf.IResolvable;
    /**
     * The GitHub organization name to manage. Use this field instead of `owner` when managing organization accounts.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github#organization GithubProvider#organization}
     *
     * @stability stable
     */
    readonly organization?: string;
    /**
     * The GitHub owner name to manage. Use this field instead of `organization` when managing individual accounts.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github#owner GithubProvider#owner}
     *
     * @stability stable
     */
    readonly owner?: string;
    /**
     * The OAuth token used to connect to GitHub.
     *
     * Anonymous mode is enabled if both `token` and `app_auth` are not set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github#token GithubProvider#token}
     *
     * @stability stable
     */
    readonly token?: string;
    /**
     * Amount of time in milliseconds to sleep in between writes to GitHub API.
     *
     * Defaults to 1000ms or 1s if not set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github#write_delay_ms GithubProvider#write_delay_ms}
     *
     * @stability stable
     */
    readonly writeDelayMs?: number;
    /**
     * Alias name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github#alias GithubProvider#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
    /**
     * app_auth block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github#app_auth GithubProvider#app_auth}
     *
     * @stability stable
     */
    readonly appAuth?: GithubProviderAppAuth[];
}
/**
 * @stability stable
 */
export interface GithubProviderAppAuth {
    /**
     * The GitHub App ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github#id GithubProvider#id}
     *
     * @stability stable
     */
    readonly id: string;
    /**
     * The GitHub App installation instance ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github#installation_id GithubProvider#installation_id}
     *
     * @stability stable
     */
    readonly installationId: string;
    /**
     * The GitHub App PEM file contents.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github#pem_file GithubProvider#pem_file}
     *
     * @stability stable
     */
    readonly pemFile: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github github}.
 *
 * @stability stable
 */
export declare class GithubProvider extends cdktf.TerraformProvider {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github github} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: GithubProviderConfig);
    private _baseUrl?;
    /**
     * @stability stable
     */
    get baseUrl(): string | undefined;
    /**
     * @stability stable
     */
    set baseUrl(value: string | undefined);
    /**
     * @stability stable
     */
    resetBaseUrl(): void;
    /**
     * @stability stable
     */
    get baseUrlInput(): string | undefined;
    private _insecure?;
    /**
     * @stability stable
     */
    get insecure(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set insecure(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetInsecure(): void;
    /**
     * @stability stable
     */
    get insecureInput(): boolean | cdktf.IResolvable | undefined;
    private _organization?;
    /**
     * @stability stable
     */
    get organization(): string | undefined;
    /**
     * @stability stable
     */
    set organization(value: string | undefined);
    /**
     * @stability stable
     */
    resetOrganization(): void;
    /**
     * @stability stable
     */
    get organizationInput(): string | undefined;
    private _owner?;
    /**
     * @stability stable
     */
    get owner(): string | undefined;
    /**
     * @stability stable
     */
    set owner(value: string | undefined);
    /**
     * @stability stable
     */
    resetOwner(): void;
    /**
     * @stability stable
     */
    get ownerInput(): string | undefined;
    private _token?;
    /**
     * @stability stable
     */
    get token(): string | undefined;
    /**
     * @stability stable
     */
    set token(value: string | undefined);
    /**
     * @stability stable
     */
    resetToken(): void;
    /**
     * @stability stable
     */
    get tokenInput(): string | undefined;
    private _writeDelayMs?;
    /**
     * @stability stable
     */
    get writeDelayMs(): number | undefined;
    /**
     * @stability stable
     */
    set writeDelayMs(value: number | undefined);
    /**
     * @stability stable
     */
    resetWriteDelayMs(): void;
    /**
     * @stability stable
     */
    get writeDelayMsInput(): number | undefined;
    private _alias?;
    /**
     * @stability stable
     */
    get alias(): string | undefined;
    /**
     * @stability stable
     */
    set alias(value: string | undefined);
    /**
     * @stability stable
     */
    resetAlias(): void;
    /**
     * @stability stable
     */
    get aliasInput(): string | undefined;
    private _appAuth?;
    /**
     * @stability stable
     */
    get appAuth(): GithubProviderAppAuth[] | undefined;
    /**
     * @stability stable
     */
    set appAuth(value: GithubProviderAppAuth[] | undefined);
    /**
     * @stability stable
     */
    resetAppAuth(): void;
    /**
     * @stability stable
     */
    get appAuthInput(): GithubProviderAppAuth[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
