import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGithubUserConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/user.html#username DataGithubUser#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/d/user.html github_user}.
 *
 * @stability stable
 */
export declare class DataGithubUser extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/d/user.html github_user} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGithubUserConfig);
    /**
     * @stability stable
     */
    get avatarUrl(): string;
    /**
     * @stability stable
     */
    get bio(): string;
    /**
     * @stability stable
     */
    get blog(): string;
    /**
     * @stability stable
     */
    get company(): string;
    /**
     * @stability stable
     */
    get createdAt(): string;
    /**
     * @stability stable
     */
    get email(): string;
    /**
     * @stability stable
     */
    get followers(): number;
    /**
     * @stability stable
     */
    get following(): number;
    /**
     * @stability stable
     */
    get gpgKeys(): string[];
    /**
     * @stability stable
     */
    get gravatarId(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    get login(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get nodeId(): string;
    /**
     * @stability stable
     */
    get publicGists(): number;
    /**
     * @stability stable
     */
    get publicRepos(): number;
    /**
     * @stability stable
     */
    get siteAdmin(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get sshKeys(): string[];
    /**
     * @stability stable
     */
    get updatedAt(): string;
    private _username;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
