import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGithubTeamConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/team.html#slug DataGithubTeam#slug}.
     *
     * @stability stable
     */
    readonly slug: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/d/team.html github_team}.
 *
 * @stability stable
 */
export declare class DataGithubTeam extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/d/team.html github_team} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGithubTeamConfig);
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get members(): string[];
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get nodeId(): string;
    /**
     * @stability stable
     */
    get permission(): string;
    /**
     * @stability stable
     */
    get privacy(): string;
    /**
     * @stability stable
     */
    get repositories(): string[];
    private _slug;
    /**
     * @stability stable
     */
    get slug(): string;
    /**
     * @stability stable
     */
    set slug(value: string);
    /**
     * @stability stable
     */
    get slugInput(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
