import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGithubRepositoryConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository.html#description DataGithubRepository#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository.html#full_name DataGithubRepository#full_name}.
     *
     * @stability stable
     */
    readonly fullName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository.html#homepage_url DataGithubRepository#homepage_url}.
     *
     * @stability stable
     */
    readonly homepageUrl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository.html#name DataGithubRepository#name}.
     *
     * @stability stable
     */
    readonly name?: string;
}
/**
 * @stability stable
 */
export declare class DataGithubRepositoryBranches extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get protected(): any;
}
/**
 * @stability stable
 */
export declare class DataGithubRepositoryPagesSource extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get branch(): string;
    /**
     * @stability stable
     */
    get path(): string;
}
/**
 * @stability stable
 */
export declare class DataGithubRepositoryPages extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get cname(): string;
    /**
     * @stability stable
     */
    get custom404(): any;
    /**
     * @stability stable
     */
    get htmlUrl(): string;
    /**
     * @stability stable
     */
    get source(): any;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get url(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/d/repository.html github_repository}.
 *
 * @stability stable
 */
export declare class DataGithubRepository extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/d/repository.html github_repository} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataGithubRepositoryConfig);
    /**
     * @stability stable
     */
    get allowMergeCommit(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get allowRebaseMerge(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get allowSquashMerge(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get archived(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    branches(index: string): DataGithubRepositoryBranches;
    /**
     * @stability stable
     */
    get defaultBranch(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _fullName?;
    /**
     * @stability stable
     */
    get fullName(): string;
    /**
     * @stability stable
     */
    set fullName(value: string);
    /**
     * @stability stable
     */
    resetFullName(): void;
    /**
     * @stability stable
     */
    get fullNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get gitCloneUrl(): string;
    /**
     * @stability stable
     */
    get hasDownloads(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get hasIssues(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get hasProjects(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get hasWiki(): cdktf.IResolvable;
    private _homepageUrl?;
    /**
     * @stability stable
     */
    get homepageUrl(): string;
    /**
     * @stability stable
     */
    set homepageUrl(value: string);
    /**
     * @stability stable
     */
    resetHomepageUrl(): void;
    /**
     * @stability stable
     */
    get homepageUrlInput(): string | undefined;
    /**
     * @stability stable
     */
    get htmlUrl(): string;
    /**
     * @stability stable
     */
    get httpCloneUrl(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get nodeId(): string;
    /**
     * @stability stable
     */
    pages(index: string): DataGithubRepositoryPages;
    /**
     * @stability stable
     */
    get private(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get repoId(): number;
    /**
     * @stability stable
     */
    get sshCloneUrl(): string;
    /**
     * @stability stable
     */
    get svnUrl(): string;
    /**
     * @stability stable
     */
    get topics(): string[];
    /**
     * @stability stable
     */
    get visibility(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
