import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGithubRepositoryPullRequestsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html#base_ref DataGithubRepositoryPullRequests#base_ref}.
     *
     * @stability stable
     */
    readonly baseRef?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html#base_repository DataGithubRepositoryPullRequests#base_repository}.
     *
     * @stability stable
     */
    readonly baseRepository: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html#head_ref DataGithubRepositoryPullRequests#head_ref}.
     *
     * @stability stable
     */
    readonly headRef?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html#owner DataGithubRepositoryPullRequests#owner}.
     *
     * @stability stable
     */
    readonly owner?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html#sort_by DataGithubRepositoryPullRequests#sort_by}.
     *
     * @stability stable
     */
    readonly sortBy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html#sort_direction DataGithubRepositoryPullRequests#sort_direction}.
     *
     * @stability stable
     */
    readonly sortDirection?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html#state DataGithubRepositoryPullRequests#state}.
     *
     * @stability stable
     */
    readonly state?: string;
}
/**
 * @stability stable
 */
export declare class DataGithubRepositoryPullRequestsResults extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get baseRef(): string;
    /**
     * @stability stable
     */
    get baseSha(): string;
    /**
     * @stability stable
     */
    get body(): string;
    /**
     * @stability stable
     */
    get draft(): any;
    /**
     * @stability stable
     */
    get headOwner(): string;
    /**
     * @stability stable
     */
    get headRef(): string;
    /**
     * @stability stable
     */
    get headRepository(): string;
    /**
     * @stability stable
     */
    get headSha(): string;
    /**
     * @stability stable
     */
    get labels(): string[];
    /**
     * @stability stable
     */
    get maintainerCanModify(): any;
    /**
     * @stability stable
     */
    get number(): number;
    /**
     * @stability stable
     */
    get openedAt(): number;
    /**
     * @stability stable
     */
    get openedBy(): string;
    /**
     * @stability stable
     */
    get state(): string;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    get updatedAt(): number;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html github_repository_pull_requests}.
 *
 * @stability stable
 */
export declare class DataGithubRepositoryPullRequests extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/d/repository_pull_requests.html github_repository_pull_requests} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGithubRepositoryPullRequestsConfig);
    private _baseRef?;
    /**
     * @stability stable
     */
    get baseRef(): string;
    /**
     * @stability stable
     */
    set baseRef(value: string);
    /**
     * @stability stable
     */
    resetBaseRef(): void;
    /**
     * @stability stable
     */
    get baseRefInput(): string | undefined;
    private _baseRepository;
    /**
     * @stability stable
     */
    get baseRepository(): string;
    /**
     * @stability stable
     */
    set baseRepository(value: string);
    /**
     * @stability stable
     */
    get baseRepositoryInput(): string;
    private _headRef?;
    /**
     * @stability stable
     */
    get headRef(): string;
    /**
     * @stability stable
     */
    set headRef(value: string);
    /**
     * @stability stable
     */
    resetHeadRef(): void;
    /**
     * @stability stable
     */
    get headRefInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _owner?;
    /**
     * @stability stable
     */
    get owner(): string;
    /**
     * @stability stable
     */
    set owner(value: string);
    /**
     * @stability stable
     */
    resetOwner(): void;
    /**
     * @stability stable
     */
    get ownerInput(): string | undefined;
    /**
     * @stability stable
     */
    results(index: string): DataGithubRepositoryPullRequestsResults;
    private _sortBy?;
    /**
     * @stability stable
     */
    get sortBy(): string;
    /**
     * @stability stable
     */
    set sortBy(value: string);
    /**
     * @stability stable
     */
    resetSortBy(): void;
    /**
     * @stability stable
     */
    get sortByInput(): string | undefined;
    private _sortDirection?;
    /**
     * @stability stable
     */
    get sortDirection(): string;
    /**
     * @stability stable
     */
    set sortDirection(value: string);
    /**
     * @stability stable
     */
    resetSortDirection(): void;
    /**
     * @stability stable
     */
    get sortDirectionInput(): string | undefined;
    private _state?;
    /**
     * @stability stable
     */
    get state(): string;
    /**
     * @stability stable
     */
    set state(value: string);
    /**
     * @stability stable
     */
    resetState(): void;
    /**
     * @stability stable
     */
    get stateInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
