import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGithubRepositoryPullRequestConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_request.html#base_repository DataGithubRepositoryPullRequest#base_repository}.
     *
     * @stability stable
     */
    readonly baseRepository: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_request.html#number DataGithubRepositoryPullRequest#number}.
     *
     * @stability stable
     */
    readonly number: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_pull_request.html#owner DataGithubRepositoryPullRequest#owner}.
     *
     * @stability stable
     */
    readonly owner?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/d/repository_pull_request.html github_repository_pull_request}.
 *
 * @stability stable
 */
export declare class DataGithubRepositoryPullRequest extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/d/repository_pull_request.html github_repository_pull_request} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGithubRepositoryPullRequestConfig);
    /**
     * @stability stable
     */
    get baseRef(): string;
    private _baseRepository;
    /**
     * @stability stable
     */
    get baseRepository(): string;
    /**
     * @stability stable
     */
    set baseRepository(value: string);
    /**
     * @stability stable
     */
    get baseRepositoryInput(): string;
    /**
     * @stability stable
     */
    get baseSha(): string;
    /**
     * @stability stable
     */
    get body(): string;
    /**
     * @stability stable
     */
    get draft(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get headOwner(): string;
    /**
     * @stability stable
     */
    get headRef(): string;
    /**
     * @stability stable
     */
    get headRepository(): string;
    /**
     * @stability stable
     */
    get headSha(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get labels(): string[];
    /**
     * @stability stable
     */
    get maintainerCanModify(): cdktf.IResolvable;
    private _number;
    /**
     * @stability stable
     */
    get number(): number;
    /**
     * @stability stable
     */
    set number(value: number);
    /**
     * @stability stable
     */
    get numberInput(): number;
    /**
     * @stability stable
     */
    get openedAt(): number;
    /**
     * @stability stable
     */
    get openedBy(): string;
    private _owner?;
    /**
     * @stability stable
     */
    get owner(): string;
    /**
     * @stability stable
     */
    set owner(value: string);
    /**
     * @stability stable
     */
    resetOwner(): void;
    /**
     * @stability stable
     */
    get ownerInput(): string | undefined;
    /**
     * @stability stable
     */
    get state(): string;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    get updatedAt(): number;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
