import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGithubRepositoryFileConfig extends cdktf.TerraformMetaArguments {
    /**
     * The branch name, defaults to "main".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_file.html#branch DataGithubRepositoryFile#branch}
     *
     * @stability stable
     */
    readonly branch?: string;
    /**
     * The file path to manage.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_file.html#file DataGithubRepositoryFile#file}
     *
     * @stability stable
     */
    readonly file: string;
    /**
     * The repository name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repository_file.html#repository DataGithubRepositoryFile#repository}
     *
     * @stability stable
     */
    readonly repository: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/d/repository_file.html github_repository_file}.
 *
 * @stability stable
 */
export declare class DataGithubRepositoryFile extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/d/repository_file.html github_repository_file} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGithubRepositoryFileConfig);
    private _branch?;
    /**
     * @stability stable
     */
    get branch(): string;
    /**
     * @stability stable
     */
    set branch(value: string);
    /**
     * @stability stable
     */
    resetBranch(): void;
    /**
     * @stability stable
     */
    get branchInput(): string | undefined;
    /**
     * @stability stable
     */
    get commitAuthor(): string;
    /**
     * @stability stable
     */
    get commitEmail(): string;
    /**
     * @stability stable
     */
    get commitMessage(): string;
    /**
     * @stability stable
     */
    get commitSha(): string;
    /**
     * @stability stable
     */
    get content(): string;
    private _file;
    /**
     * @stability stable
     */
    get file(): string;
    /**
     * @stability stable
     */
    set file(value: string);
    /**
     * @stability stable
     */
    get fileInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _repository;
    /**
     * @stability stable
     */
    get repository(): string;
    /**
     * @stability stable
     */
    set repository(value: string);
    /**
     * @stability stable
     */
    get repositoryInput(): string;
    /**
     * @stability stable
     */
    get sha(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
