import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGithubRepositoriesConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repositories.html#query DataGithubRepositories#query}.
     *
     * @stability stable
     */
    readonly query: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/repositories.html#sort DataGithubRepositories#sort}.
     *
     * @stability stable
     */
    readonly sort?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/d/repositories.html github_repositories}.
 *
 * @stability stable
 */
export declare class DataGithubRepositories extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/d/repositories.html github_repositories} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGithubRepositoriesConfig);
    /**
     * @stability stable
     */
    get fullNames(): string[];
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get names(): string[];
    private _query;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string;
    private _sort?;
    /**
     * @stability stable
     */
    get sort(): string;
    /**
     * @stability stable
     */
    set sort(value: string);
    /**
     * @stability stable
     */
    resetSort(): void;
    /**
     * @stability stable
     */
    get sortInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
