import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGithubReleaseConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/release.html#owner DataGithubRelease#owner}.
     *
     * @stability stable
     */
    readonly owner: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/release.html#release_id DataGithubRelease#release_id}.
     *
     * @stability stable
     */
    readonly releaseId?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/release.html#release_tag DataGithubRelease#release_tag}.
     *
     * @stability stable
     */
    readonly releaseTag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/release.html#repository DataGithubRelease#repository}.
     *
     * @stability stable
     */
    readonly repository: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/release.html#retrieve_by DataGithubRelease#retrieve_by}.
     *
     * @stability stable
     */
    readonly retrieveBy: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/d/release.html github_release}.
 *
 * @stability stable
 */
export declare class DataGithubRelease extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/d/release.html github_release} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGithubReleaseConfig);
    /**
     * @stability stable
     */
    get assertsUrl(): string;
    /**
     * @stability stable
     */
    get body(): string;
    /**
     * @stability stable
     */
    get createdAt(): string;
    /**
     * @stability stable
     */
    get draft(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get htmlUrl(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _owner;
    /**
     * @stability stable
     */
    get owner(): string;
    /**
     * @stability stable
     */
    set owner(value: string);
    /**
     * @stability stable
     */
    get ownerInput(): string;
    /**
     * @stability stable
     */
    get prerelease(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get publishedAt(): string;
    private _releaseId?;
    /**
     * @stability stable
     */
    get releaseId(): number;
    /**
     * @stability stable
     */
    set releaseId(value: number);
    /**
     * @stability stable
     */
    resetReleaseId(): void;
    /**
     * @stability stable
     */
    get releaseIdInput(): number | undefined;
    private _releaseTag?;
    /**
     * @stability stable
     */
    get releaseTag(): string;
    /**
     * @stability stable
     */
    set releaseTag(value: string);
    /**
     * @stability stable
     */
    resetReleaseTag(): void;
    /**
     * @stability stable
     */
    get releaseTagInput(): string | undefined;
    private _repository;
    /**
     * @stability stable
     */
    get repository(): string;
    /**
     * @stability stable
     */
    set repository(value: string);
    /**
     * @stability stable
     */
    get repositoryInput(): string;
    private _retrieveBy;
    /**
     * @stability stable
     */
    get retrieveBy(): string;
    /**
     * @stability stable
     */
    set retrieveBy(value: string);
    /**
     * @stability stable
     */
    get retrieveByInput(): string;
    /**
     * @stability stable
     */
    get tarballUrl(): string;
    /**
     * @stability stable
     */
    get targetCommitish(): string;
    /**
     * @stability stable
     */
    get uploadUrl(): string;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    get zipballUrl(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
