import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGithubOrganizationTeamsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/organization_teams.html#root_teams_only DataGithubOrganizationTeams#root_teams_only}.
     *
     * @stability stable
     */
    readonly rootTeamsOnly?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class DataGithubOrganizationTeamsTeams extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get id(): number;
    /**
     * @stability stable
     */
    get members(): string[];
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get nodeId(): string;
    /**
     * @stability stable
     */
    get privacy(): string;
    /**
     * @stability stable
     */
    get repositories(): string[];
    /**
     * @stability stable
     */
    get slug(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/d/organization_teams.html github_organization_teams}.
 *
 * @stability stable
 */
export declare class DataGithubOrganizationTeams extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/d/organization_teams.html github_organization_teams} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataGithubOrganizationTeamsConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _rootTeamsOnly?;
    /**
     * @stability stable
     */
    get rootTeamsOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set rootTeamsOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRootTeamsOnly(): void;
    /**
     * @stability stable
     */
    get rootTeamsOnlyInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    teams(index: string): DataGithubOrganizationTeamsTeams;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
