import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGithubMembershipConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/membership.html#organization DataGithubMembership#organization}.
     *
     * @stability stable
     */
    readonly organization?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/membership.html#username DataGithubMembership#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/d/membership.html github_membership}.
 *
 * @stability stable
 */
export declare class DataGithubMembership extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/d/membership.html github_membership} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGithubMembershipConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _organization?;
    /**
     * @stability stable
     */
    get organization(): string;
    /**
     * @stability stable
     */
    set organization(value: string);
    /**
     * @stability stable
     */
    resetOrganization(): void;
    /**
     * @stability stable
     */
    get organizationInput(): string | undefined;
    /**
     * @stability stable
     */
    get role(): string;
    private _username;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
