import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGithubCollaboratorsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/collaborators.html#affiliation DataGithubCollaborators#affiliation}.
     *
     * @stability stable
     */
    readonly affiliation?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/collaborators.html#owner DataGithubCollaborators#owner}.
     *
     * @stability stable
     */
    readonly owner: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/d/collaborators.html#repository DataGithubCollaborators#repository}.
     *
     * @stability stable
     */
    readonly repository: string;
}
/**
 * @stability stable
 */
export declare class DataGithubCollaboratorsCollaborator extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get eventsUrl(): string;
    /**
     * @stability stable
     */
    get followersUrl(): string;
    /**
     * @stability stable
     */
    get followingUrl(): string;
    /**
     * @stability stable
     */
    get gistsUrl(): string;
    /**
     * @stability stable
     */
    get htmlUrl(): string;
    /**
     * @stability stable
     */
    get id(): number;
    /**
     * @stability stable
     */
    get login(): string;
    /**
     * @stability stable
     */
    get organizationsUrl(): string;
    /**
     * @stability stable
     */
    get permission(): string;
    /**
     * @stability stable
     */
    get receivedEventsUrl(): string;
    /**
     * @stability stable
     */
    get reposUrl(): string;
    /**
     * @stability stable
     */
    get siteAdmin(): any;
    /**
     * @stability stable
     */
    get starredUrl(): string;
    /**
     * @stability stable
     */
    get subscriptionsUrl(): string;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get url(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/d/collaborators.html github_collaborators}.
 *
 * @stability stable
 */
export declare class DataGithubCollaborators extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/d/collaborators.html github_collaborators} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGithubCollaboratorsConfig);
    private _affiliation?;
    /**
     * @stability stable
     */
    get affiliation(): string;
    /**
     * @stability stable
     */
    set affiliation(value: string);
    /**
     * @stability stable
     */
    resetAffiliation(): void;
    /**
     * @stability stable
     */
    get affiliationInput(): string | undefined;
    /**
     * @stability stable
     */
    collaborator(index: string): DataGithubCollaboratorsCollaborator;
    /**
     * @stability stable
     */
    get id(): string;
    private _owner;
    /**
     * @stability stable
     */
    get owner(): string;
    /**
     * @stability stable
     */
    set owner(value: string);
    /**
     * @stability stable
     */
    get ownerInput(): string;
    private _repository;
    /**
     * @stability stable
     */
    get repository(): string;
    /**
     * @stability stable
     */
    set repository(value: string);
    /**
     * @stability stable
     */
    get repositoryInput(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
