import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BranchConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch.html#branch Branch#branch}.
     *
     * @stability stable
     */
    readonly branch: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch.html#repository Branch#repository}.
     *
     * @stability stable
     */
    readonly repository: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch.html#source_branch Branch#source_branch}.
     *
     * @stability stable
     */
    readonly sourceBranch?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch.html#source_sha Branch#source_sha}.
     *
     * @stability stable
     */
    readonly sourceSha?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/r/branch.html github_branch}.
 *
 * @stability stable
 */
export declare class Branch extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/r/branch.html github_branch} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BranchConfig);
    private _branch;
    /**
     * @stability stable
     */
    get branch(): string;
    /**
     * @stability stable
     */
    set branch(value: string);
    /**
     * @stability stable
     */
    get branchInput(): string;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get ref(): string;
    private _repository;
    /**
     * @stability stable
     */
    get repository(): string;
    /**
     * @stability stable
     */
    set repository(value: string);
    /**
     * @stability stable
     */
    get repositoryInput(): string;
    /**
     * @stability stable
     */
    get sha(): string;
    private _sourceBranch?;
    /**
     * @stability stable
     */
    get sourceBranch(): string;
    /**
     * @stability stable
     */
    set sourceBranch(value: string);
    /**
     * @stability stable
     */
    resetSourceBranch(): void;
    /**
     * @stability stable
     */
    get sourceBranchInput(): string | undefined;
    private _sourceSha?;
    /**
     * @stability stable
     */
    get sourceSha(): string;
    /**
     * @stability stable
     */
    set sourceSha(value: string);
    /**
     * @stability stable
     */
    resetSourceSha(): void;
    /**
     * @stability stable
     */
    get sourceShaInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
