import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BranchProtectionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#allows_deletions BranchProtection#allows_deletions}.
     *
     * @stability stable
     */
    readonly allowsDeletions?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#allows_force_pushes BranchProtection#allows_force_pushes}.
     *
     * @stability stable
     */
    readonly allowsForcePushes?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#enforce_admins BranchProtection#enforce_admins}.
     *
     * @stability stable
     */
    readonly enforceAdmins?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#pattern BranchProtection#pattern}.
     *
     * @stability stable
     */
    readonly pattern: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#push_restrictions BranchProtection#push_restrictions}.
     *
     * @stability stable
     */
    readonly pushRestrictions?: string[];
    /**
     * Node ID or name of repository.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#repository_id BranchProtection#repository_id}
     *
     * @stability stable
     */
    readonly repositoryId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#require_signed_commits BranchProtection#require_signed_commits}.
     *
     * @stability stable
     */
    readonly requireSignedCommits?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#required_linear_history BranchProtection#required_linear_history}.
     *
     * @stability stable
     */
    readonly requiredLinearHistory?: boolean | cdktf.IResolvable;
    /**
     * required_pull_request_reviews block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#required_pull_request_reviews BranchProtection#required_pull_request_reviews}
     *
     * @stability stable
     */
    readonly requiredPullRequestReviews?: BranchProtectionRequiredPullRequestReviews[];
    /**
     * required_status_checks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#required_status_checks BranchProtection#required_status_checks}
     *
     * @stability stable
     */
    readonly requiredStatusChecks?: BranchProtectionRequiredStatusChecks[];
}
/**
 * @stability stable
 */
export interface BranchProtectionRequiredPullRequestReviews {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#dismiss_stale_reviews BranchProtection#dismiss_stale_reviews}.
     *
     * @stability stable
     */
    readonly dismissStaleReviews?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#dismissal_restrictions BranchProtection#dismissal_restrictions}.
     *
     * @stability stable
     */
    readonly dismissalRestrictions?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#require_code_owner_reviews BranchProtection#require_code_owner_reviews}.
     *
     * @stability stable
     */
    readonly requireCodeOwnerReviews?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#required_approving_review_count BranchProtection#required_approving_review_count}.
     *
     * @stability stable
     */
    readonly requiredApprovingReviewCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#restrict_dismissals BranchProtection#restrict_dismissals}.
     *
     * @stability stable
     */
    readonly restrictDismissals?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface BranchProtectionRequiredStatusChecks {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#contexts BranchProtection#contexts}.
     *
     * @stability stable
     */
    readonly contexts?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html#strict BranchProtection#strict}.
     *
     * @stability stable
     */
    readonly strict?: boolean | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html github_branch_protection}.
 *
 * @stability stable
 */
export declare class BranchProtection extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/r/branch_protection.html github_branch_protection} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BranchProtectionConfig);
    private _allowsDeletions?;
    /**
     * @stability stable
     */
    get allowsDeletions(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowsDeletions(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowsDeletions(): void;
    /**
     * @stability stable
     */
    get allowsDeletionsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowsForcePushes?;
    /**
     * @stability stable
     */
    get allowsForcePushes(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowsForcePushes(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowsForcePushes(): void;
    /**
     * @stability stable
     */
    get allowsForcePushesInput(): boolean | cdktf.IResolvable | undefined;
    private _enforceAdmins?;
    /**
     * @stability stable
     */
    get enforceAdmins(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enforceAdmins(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnforceAdmins(): void;
    /**
     * @stability stable
     */
    get enforceAdminsInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _pattern;
    /**
     * @stability stable
     */
    get pattern(): string;
    /**
     * @stability stable
     */
    set pattern(value: string);
    /**
     * @stability stable
     */
    get patternInput(): string;
    private _pushRestrictions?;
    /**
     * @stability stable
     */
    get pushRestrictions(): string[];
    /**
     * @stability stable
     */
    set pushRestrictions(value: string[]);
    /**
     * @stability stable
     */
    resetPushRestrictions(): void;
    /**
     * @stability stable
     */
    get pushRestrictionsInput(): string[] | undefined;
    private _repositoryId;
    /**
     * @stability stable
     */
    get repositoryId(): string;
    /**
     * @stability stable
     */
    set repositoryId(value: string);
    /**
     * @stability stable
     */
    get repositoryIdInput(): string;
    private _requireSignedCommits?;
    /**
     * @stability stable
     */
    get requireSignedCommits(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requireSignedCommits(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequireSignedCommits(): void;
    /**
     * @stability stable
     */
    get requireSignedCommitsInput(): boolean | cdktf.IResolvable | undefined;
    private _requiredLinearHistory?;
    /**
     * @stability stable
     */
    get requiredLinearHistory(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requiredLinearHistory(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequiredLinearHistory(): void;
    /**
     * @stability stable
     */
    get requiredLinearHistoryInput(): boolean | cdktf.IResolvable | undefined;
    private _requiredPullRequestReviews?;
    /**
     * @stability stable
     */
    get requiredPullRequestReviews(): BranchProtectionRequiredPullRequestReviews[];
    /**
     * @stability stable
     */
    set requiredPullRequestReviews(value: BranchProtectionRequiredPullRequestReviews[]);
    /**
     * @stability stable
     */
    resetRequiredPullRequestReviews(): void;
    /**
     * @stability stable
     */
    get requiredPullRequestReviewsInput(): BranchProtectionRequiredPullRequestReviews[] | undefined;
    private _requiredStatusChecks?;
    /**
     * @stability stable
     */
    get requiredStatusChecks(): BranchProtectionRequiredStatusChecks[];
    /**
     * @stability stable
     */
    set requiredStatusChecks(value: BranchProtectionRequiredStatusChecks[]);
    /**
     * @stability stable
     */
    resetRequiredStatusChecks(): void;
    /**
     * @stability stable
     */
    get requiredStatusChecksInput(): BranchProtectionRequiredStatusChecks[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
