import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BranchProtectionV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#branch BranchProtectionV3#branch}.
     *
     * @stability stable
     */
    readonly branch: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#enforce_admins BranchProtectionV3#enforce_admins}.
     *
     * @stability stable
     */
    readonly enforceAdmins?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#repository BranchProtectionV3#repository}.
     *
     * @stability stable
     */
    readonly repository: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#require_signed_commits BranchProtectionV3#require_signed_commits}.
     *
     * @stability stable
     */
    readonly requireSignedCommits?: boolean | cdktf.IResolvable;
    /**
     * required_pull_request_reviews block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#required_pull_request_reviews BranchProtectionV3#required_pull_request_reviews}
     *
     * @stability stable
     */
    readonly requiredPullRequestReviews?: BranchProtectionV3RequiredPullRequestReviews[];
    /**
     * required_status_checks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#required_status_checks BranchProtectionV3#required_status_checks}
     *
     * @stability stable
     */
    readonly requiredStatusChecks?: BranchProtectionV3RequiredStatusChecks[];
    /**
     * restrictions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#restrictions BranchProtectionV3#restrictions}
     *
     * @stability stable
     */
    readonly restrictions?: BranchProtectionV3Restrictions[];
}
/**
 * @stability stable
 */
export interface BranchProtectionV3RequiredPullRequestReviews {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#dismiss_stale_reviews BranchProtectionV3#dismiss_stale_reviews}.
     *
     * @stability stable
     */
    readonly dismissStaleReviews?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#dismissal_teams BranchProtectionV3#dismissal_teams}.
     *
     * @stability stable
     */
    readonly dismissalTeams?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#dismissal_users BranchProtectionV3#dismissal_users}.
     *
     * @stability stable
     */
    readonly dismissalUsers?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#include_admins BranchProtectionV3#include_admins}.
     *
     * @stability stable
     */
    readonly includeAdmins?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#require_code_owner_reviews BranchProtectionV3#require_code_owner_reviews}.
     *
     * @stability stable
     */
    readonly requireCodeOwnerReviews?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#required_approving_review_count BranchProtectionV3#required_approving_review_count}.
     *
     * @stability stable
     */
    readonly requiredApprovingReviewCount?: number;
}
/**
 * @stability stable
 */
export interface BranchProtectionV3RequiredStatusChecks {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#contexts BranchProtectionV3#contexts}.
     *
     * @stability stable
     */
    readonly contexts?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#include_admins BranchProtectionV3#include_admins}.
     *
     * @stability stable
     */
    readonly includeAdmins?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#strict BranchProtectionV3#strict}.
     *
     * @stability stable
     */
    readonly strict?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface BranchProtectionV3Restrictions {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#apps BranchProtectionV3#apps}.
     *
     * @stability stable
     */
    readonly apps?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#teams BranchProtectionV3#teams}.
     *
     * @stability stable
     */
    readonly teams?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html#users BranchProtectionV3#users}.
     *
     * @stability stable
     */
    readonly users?: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html github_branch_protection_v3}.
 *
 * @stability stable
 */
export declare class BranchProtectionV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/github/r/branch_protection_v3.html github_branch_protection_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BranchProtectionV3Config);
    private _branch;
    /**
     * @stability stable
     */
    get branch(): string;
    /**
     * @stability stable
     */
    set branch(value: string);
    /**
     * @stability stable
     */
    get branchInput(): string;
    private _enforceAdmins?;
    /**
     * @stability stable
     */
    get enforceAdmins(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enforceAdmins(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnforceAdmins(): void;
    /**
     * @stability stable
     */
    get enforceAdminsInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _repository;
    /**
     * @stability stable
     */
    get repository(): string;
    /**
     * @stability stable
     */
    set repository(value: string);
    /**
     * @stability stable
     */
    get repositoryInput(): string;
    private _requireSignedCommits?;
    /**
     * @stability stable
     */
    get requireSignedCommits(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requireSignedCommits(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequireSignedCommits(): void;
    /**
     * @stability stable
     */
    get requireSignedCommitsInput(): boolean | cdktf.IResolvable | undefined;
    private _requiredPullRequestReviews?;
    /**
     * @stability stable
     */
    get requiredPullRequestReviews(): BranchProtectionV3RequiredPullRequestReviews[];
    /**
     * @stability stable
     */
    set requiredPullRequestReviews(value: BranchProtectionV3RequiredPullRequestReviews[]);
    /**
     * @stability stable
     */
    resetRequiredPullRequestReviews(): void;
    /**
     * @stability stable
     */
    get requiredPullRequestReviewsInput(): BranchProtectionV3RequiredPullRequestReviews[] | undefined;
    private _requiredStatusChecks?;
    /**
     * @stability stable
     */
    get requiredStatusChecks(): BranchProtectionV3RequiredStatusChecks[];
    /**
     * @stability stable
     */
    set requiredStatusChecks(value: BranchProtectionV3RequiredStatusChecks[]);
    /**
     * @stability stable
     */
    resetRequiredStatusChecks(): void;
    /**
     * @stability stable
     */
    get requiredStatusChecksInput(): BranchProtectionV3RequiredStatusChecks[] | undefined;
    private _restrictions?;
    /**
     * @stability stable
     */
    get restrictions(): BranchProtectionV3Restrictions[];
    /**
     * @stability stable
     */
    set restrictions(value: BranchProtectionV3Restrictions[]);
    /**
     * @stability stable
     */
    resetRestrictions(): void;
    /**
     * @stability stable
     */
    get restrictionsInput(): BranchProtectionV3Restrictions[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
